% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_complete_layer_upload}
\alias{ecr_complete_layer_upload}
\title{Informs Amazon ECR that the image layer upload has completed for a
specified registry, repository name, and upload ID}
\usage{
ecr_complete_layer_upload(
  registryId = NULL,
  repositoryName,
  uploadId,
  layerDigests
)
}
\arguments{
\item{registryId}{The Amazon Web Services account ID associated with the registry to which
to upload layers. If you do not specify a registry, the default registry
is assumed.}

\item{repositoryName}{[required] The name of the repository to associate with the image layer.}

\item{uploadId}{[required] The upload ID from a previous
\code{\link[=ecr_initiate_layer_upload]{initiate_layer_upload}} operation to
associate with the image layer.}

\item{layerDigests}{[required] The \code{sha256} digest of the image layer.}
}
\description{
Informs Amazon ECR that the image layer upload has completed for a specified registry, repository name, and upload ID. You can optionally provide a \code{sha256} digest of the image layer for data validation purposes.

See \url{https://www.paws-r-sdk.com/docs/ecr_complete_layer_upload/} for full documentation.
}
\keyword{internal}
