% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_verified_access_trust_provider}
\alias{ec2_create_verified_access_trust_provider}
\title{A trust provider is a third-party entity that creates, maintains, and
manages identity information for users and devices}
\usage{
ec2_create_verified_access_trust_provider(
  TrustProviderType,
  UserTrustProviderType = NULL,
  DeviceTrustProviderType = NULL,
  OidcOptions = NULL,
  DeviceOptions = NULL,
  PolicyReferenceName,
  Description = NULL,
  TagSpecifications = NULL,
  ClientToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{TrustProviderType}{[required] The type of trust provider.}

\item{UserTrustProviderType}{The type of user-based trust provider. This parameter is required when
the provider type is \code{user}.}

\item{DeviceTrustProviderType}{The type of device-based trust provider. This parameter is required when
the provider type is \code{device}.}

\item{OidcOptions}{The options for a OpenID Connect-compatible user-identity trust
provider. This parameter is required when the provider type is \code{user}.}

\item{DeviceOptions}{The options for a device-based trust provider. This parameter is
required when the provider type is \code{device}.}

\item{PolicyReferenceName}{[required] The identifier to be used when working with policy rules.}

\item{Description}{A description for the Verified Access trust provider.}

\item{TagSpecifications}{The tags to assign to the Verified Access trust provider.}

\item{ClientToken}{A unique, case-sensitive token that you provide to ensure idempotency of
your modification request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{Ensuring Idempotency}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
A trust provider is a third-party entity that creates, maintains, and manages identity information for users and devices. When an application request is made, the identity information sent by the trust provider is evaluated by Verified Access before allowing or denying the application request.

See \url{https://www.paws-r-sdk.com/docs/ec2_create_verified_access_trust_provider/} for full documentation.
}
\keyword{internal}
