% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_function_configuration}
\alias{lambda_get_function_configuration}
\title{Returns the version-specific settings of a Lambda function or version}
\usage{
lambda_get_function_configuration(FunctionName, Qualifier = NULL)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function, version, or alias.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function} (name-only), \verb{my-function:v1}
(with alias).
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

You can append a version number or alias to any of the formats. The
length constraint applies only to the full ARN. If you specify only the
function name, it is limited to 64 characters in length.}

\item{Qualifier}{Specify a version or alias to get details about a published version of
the function.}
}
\description{
Returns the version-specific settings of a Lambda function or version. The output includes only options that can vary between versions of a function. To modify these settings, use \code{\link[=lambda_update_function_configuration]{update_function_configuration}}.

See \url{https://paws-r.github.io/docs/lambda/get_function_configuration.html} for full documentation.
}
\keyword{internal}
