% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_associate_identity_provider_config}
\alias{eks_associate_identity_provider_config}
\title{Associate an identity provider configuration to a cluster}
\usage{
eks_associate_identity_provider_config(
  clusterName,
  oidc,
  tags = NULL,
  clientRequestToken = NULL
)
}
\arguments{
\item{clusterName}{[required] The name of the cluster to associate the configuration to.}

\item{oidc}{[required] An object that represents an OpenID Connect (OIDC) identity provider
configuration.}

\item{tags}{The metadata to apply to the configuration to assist with categorization
and organization. Each tag consists of a key and an optional value. You
define both.}

\item{clientRequestToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request.}
}
\description{
Associate an identity provider configuration to a cluster.

See \url{https://paws-r.github.io/docs/eks/associate_identity_provider_config.html} for full documentation.
}
\keyword{internal}
