% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_put_image}
\alias{ecr_put_image}
\title{Creates or updates the image manifest and tags associated with an image}
\usage{
ecr_put_image(
  registryId = NULL,
  repositoryName,
  imageManifest,
  imageManifestMediaType = NULL,
  imageTag = NULL,
  imageDigest = NULL
)
}
\arguments{
\item{registryId}{The Amazon Web Services account ID associated with the registry that
contains the repository in which to put the image. If you do not specify
a registry, the default registry is assumed.}

\item{repositoryName}{[required] The name of the repository in which to put the image.}

\item{imageManifest}{[required] The image manifest corresponding to the image to be uploaded.}

\item{imageManifestMediaType}{The media type of the image manifest. If you push an image manifest that
does not contain the \code{mediaType} field, you must specify the
\code{imageManifestMediaType} in the request.}

\item{imageTag}{The tag to associate with the image. This parameter is required for
images that use the Docker Image Manifest V2 Schema 2 or Open Container
Initiative (OCI) formats.}

\item{imageDigest}{The image digest of the image manifest corresponding to the image.}
}
\description{
Creates or updates the image manifest and tags associated with an image.

See \url{https://paws-r.github.io/docs/ecr/put_image.html} for full documentation.
}
\keyword{internal}
