% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2instanceconnect_operations.R
\name{ec2instanceconnect_send_ssh_public_key}
\alias{ec2instanceconnect_send_ssh_public_key}
\title{Pushes an SSH public key to the specified EC2 instance for use by the
specified user}
\usage{
ec2instanceconnect_send_ssh_public_key(
  InstanceId,
  InstanceOSUser,
  SSHPublicKey,
  AvailabilityZone = NULL
)
}
\arguments{
\item{InstanceId}{[required] The ID of the EC2 instance.}

\item{InstanceOSUser}{[required] The OS user on the EC2 instance for whom the key can be used to
authenticate.}

\item{SSHPublicKey}{[required] The public key material. To use the public key, you must have the
matching private key.}

\item{AvailabilityZone}{The Availability Zone in which the EC2 instance was launched.}
}
\description{
Pushes an SSH public key to the specified EC2 instance for use by the specified user. The key remains for 60 seconds. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect.html}{Connect to your Linux instance using EC2 Instance Connect} in the \emph{Amazon EC2 User Guide}.

See \url{https://paws-r.github.io/docs/ec2instanceconnect/send_ssh_public_key.html} for full documentation.
}
\keyword{internal}
