% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_list_snapshots_in_recycle_bin}
\alias{ec2_list_snapshots_in_recycle_bin}
\title{Lists one or more snapshots that are currently in the Recycle Bin}
\usage{
ec2_list_snapshots_in_recycle_bin(
  MaxResults = NULL,
  NextToken = NULL,
  SnapshotIds = NULL,
  DryRun = NULL
)
}
\arguments{
\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{SnapshotIds}{The IDs of the snapshots to list. Omit this parameter to list all of the
snapshots that are in the Recycle Bin.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Lists one or more snapshots that are currently in the Recycle Bin.

See \url{https://paws-r.github.io/docs/ec2/list_snapshots_in_recycle_bin.html} for full documentation.
}
\keyword{internal}
