% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_import_key_pair}
\alias{ec2_import_key_pair}
\title{Imports the public key from an RSA or ED25519 key pair that you created
with a third-party tool}
\usage{
ec2_import_key_pair(
  DryRun = NULL,
  KeyName,
  PublicKeyMaterial,
  TagSpecifications = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{KeyName}{[required] A unique name for the key pair.}

\item{PublicKeyMaterial}{[required] The public key. For API calls, the text must be base64-encoded. For
command line tools, base64 encoding is performed for you.}

\item{TagSpecifications}{The tags to apply to the imported key pair.}
}
\description{
Imports the public key from an RSA or ED25519 key pair that you created with a third-party tool. Compare this with \code{\link[=ec2_create_key_pair]{create_key_pair}}, in which Amazon Web Services creates the key pair and gives the keys to you (Amazon Web Services keeps a copy of the public key). With ImportKeyPair, you create the key pair and give Amazon Web Services just the public key. The private key is never transferred between you and Amazon Web Services.

See \url{https://paws-r.github.io/docs/ec2/import_key_pair.html} for full documentation.
}
\keyword{internal}
