% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_spot_placement_scores}
\alias{ec2_get_spot_placement_scores}
\title{Calculates the Spot placement score for a Region or Availability Zone
based on the specified target capacity and compute requirements}
\usage{
ec2_get_spot_placement_scores(
  InstanceTypes = NULL,
  TargetCapacity,
  TargetCapacityUnitType = NULL,
  SingleAvailabilityZone = NULL,
  RegionNames = NULL,
  InstanceRequirementsWithMetadata = NULL,
  DryRun = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{InstanceTypes}{The instance types. We recommend that you specify at least three
instance types. If you specify one or two instance types, or specify
variations of a single instance type (for example, an \code{m3.xlarge} with
and without instance storage), the returned placement score will always
be low.

If you specify \code{InstanceTypes}, you can't specify
\code{InstanceRequirementsWithMetadata}.}

\item{TargetCapacity}{[required] The target capacity.}

\item{TargetCapacityUnitType}{The unit for the target capacity.

Default: \code{units} (translates to number of instances)}

\item{SingleAvailabilityZone}{Specify \code{true} so that the response returns a list of scored
Availability Zones. Otherwise, the response returns a list of scored
Regions.

A list of scored Availability Zones is useful if you want to launch all
of your Spot capacity into a single Availability Zone.}

\item{RegionNames}{The Regions used to narrow down the list of Regions to be scored. Enter
the Region code, for example, \code{us-east-1}.}

\item{InstanceRequirementsWithMetadata}{The attributes for the instance types. When you specify instance
attributes, Amazon EC2 will identify instance types with those
attributes.

If you specify \code{InstanceRequirementsWithMetadata}, you can't specify
\code{InstanceTypes}.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 1 and 1000. The default value is 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next set of results.}
}
\description{
Calculates the Spot placement score for a Region or Availability Zone based on the specified target capacity and compute requirements.

See \url{https://paws-r.github.io/docs/ec2/get_spot_placement_scores.html} for full documentation.
}
\keyword{internal}
