% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_deprovision_ipam_pool_cidr}
\alias{ec2_deprovision_ipam_pool_cidr}
\title{Deprovision a CIDR provisioned from an IPAM pool}
\usage{
ec2_deprovision_ipam_pool_cidr(DryRun = NULL, IpamPoolId, Cidr = NULL)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamPoolId}{[required] The ID of the pool that has the CIDR you want to deprovision.}

\item{Cidr}{The CIDR which you want to deprovision from the pool.}
}
\description{
Deprovision a CIDR provisioned from an IPAM pool. If you deprovision a CIDR from a pool that has a source pool, the CIDR is recycled back into the source pool. For more information, see \href{https://docs.aws.amazon.com/vpc/latest/ipam/depro-pool-cidr-ipam.html}{Deprovision pool CIDRs} in the \emph{Amazon VPC IPAM User Guide}.

See \url{https://paws-r.github.io/docs/ec2/deprovision_ipam_pool_cidr.html} for full documentation.
}
\keyword{internal}
