% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_apply_security_groups_to_client_vpn_target_network}
\alias{ec2_apply_security_groups_to_client_vpn_target_network}
\title{Applies a security group to the association between the target network
and the Client VPN endpoint}
\usage{
ec2_apply_security_groups_to_client_vpn_target_network(
  ClientVpnEndpointId,
  VpcId,
  SecurityGroupIds,
  DryRun = NULL
)
}
\arguments{
\item{ClientVpnEndpointId}{[required] The ID of the Client VPN endpoint.}

\item{VpcId}{[required] The ID of the VPC in which the associated target network is located.}

\item{SecurityGroupIds}{[required] The IDs of the security groups to apply to the associated target
network. Up to 5 security groups can be applied to an associated target
network.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Applies a security group to the association between the target network and the Client VPN endpoint. This action replaces the existing security groups with the specified security groups.

See \url{https://paws-r.github.io/docs/ec2/apply_security_groups_to_client_vpn_target_network.html} for full documentation.
}
\keyword{internal}
