% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch_operations.R
\name{batch_cancel_job}
\alias{batch_cancel_job}
\title{Cancels a job in an Batch job queue}
\usage{
batch_cancel_job(jobId, reason)
}
\arguments{
\item{jobId}{[required] The Batch job ID of the job to cancel.}

\item{reason}{[required] A message to attach to the job that explains the reason for canceling
it. This message is returned by future
\code{\link[=batch_describe_jobs]{describe_jobs}} operations on the job. This
message is also recorded in the Batch activity logs.}
}
\description{
Cancels a job in an Batch job queue. Jobs that are in the \code{SUBMITTED}, \code{PENDING}, or \code{RUNNABLE} state are canceled. Jobs that have progressed to \code{STARTING} or \code{RUNNING} aren't canceled, but the API operation still succeeds, even if no job is canceled. These jobs must be terminated with the \code{\link[=batch_terminate_job]{terminate_job}} operation.

See \url{https://paws-r.github.io/docs/batch/cancel_job.html} for full documentation.
}
\keyword{internal}
