% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apprunner_operations.R
\name{apprunner_list_operations}
\alias{apprunner_list_operations}
\title{Return a list of operations that occurred on an App Runner service}
\usage{
apprunner_list_operations(ServiceArn, NextToken = NULL, MaxResults = NULL)
}
\arguments{
\item{ServiceArn}{[required] The Amazon Resource Name (ARN) of the App Runner service that you want a
list of operations for.}

\item{NextToken}{A token from a previous result page. It's used for a paginated request.
The request retrieves the next result page. All other parameter values
must be identical to the ones specified in the initial request.

If you don't specify \code{NextToken}, the request retrieves the first result
page.}

\item{MaxResults}{The maximum number of results to include in each response (result page).
It's used for a paginated request.

If you don't specify \code{MaxResults}, the request retrieves all available
results in a single response.}
}
\description{
Return a list of operations that occurred on an App Runner service.

See \url{https://paws-r.github.io/docs/apprunner/list_operations.html} for full documentation.
}
\keyword{internal}
