% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_put_alarm}
\alias{lightsail_put_alarm}
\title{Creates or updates an alarm, and associates it with the specified metric}
\usage{
lightsail_put_alarm(alarmName, metricName, monitoredResourceName,
  comparisonOperator, threshold, evaluationPeriods, datapointsToAlarm,
  treatMissingData, contactProtocols, notificationTriggers,
  notificationEnabled)
}
\arguments{
\item{alarmName}{[required] The name for the alarm. Specify the name of an existing alarm to update,
and overwrite the previous configuration of the alarm.}

\item{metricName}{[required] The name of the metric to associate with the alarm.

You can configure up to two alarms per metric.

The following metrics are available for each resource type:
\itemize{
\item \strong{Instances}: \code{BurstCapacityPercentage}, \code{BurstCapacityTime},
\code{CPUUtilization}, \code{NetworkIn}, \code{NetworkOut}, \code{StatusCheckFailed},
\code{StatusCheckFailed_Instance}, and \code{StatusCheckFailed_System}.
\item \strong{Load balancers}: \code{ClientTLSNegotiationErrorCount},
\code{HealthyHostCount}, \code{UnhealthyHostCount}, \code{HTTPCode_LB_4XX_Count},
\code{HTTPCode_LB_5XX_Count}, \code{HTTPCode_Instance_2XX_Count},
\code{HTTPCode_Instance_3XX_Count}, \code{HTTPCode_Instance_4XX_Count},
\code{HTTPCode_Instance_5XX_Count}, \code{InstanceResponseTime},
\code{RejectedConnectionCount}, and \code{RequestCount}.
\item \strong{Relational databases}: \code{CPUUtilization}, \code{DatabaseConnections},
\code{DiskQueueDepth}, \code{FreeStorageSpace}, \code{NetworkReceiveThroughput},
and \code{NetworkTransmitThroughput}.
}

For more information about these metrics, see \href{https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-resource-health-metrics#available-metrics}{Metrics available in Lightsail}.}

\item{monitoredResourceName}{[required] The name of the Lightsail resource that will be monitored.

Instances, load balancers, and relational databases are the only
Lightsail resources that can currently be monitored by alarms.}

\item{comparisonOperator}{[required] The arithmetic operation to use when comparing the specified statistic
to the threshold. The specified statistic value is used as the first
operand.}

\item{threshold}{[required] The value against which the specified statistic is compared.}

\item{evaluationPeriods}{[required] The number of most recent periods over which data is compared to the
specified threshold. If you are setting an \"M out of N\" alarm, this
value (\code{evaluationPeriods}) is the N.

If you are setting an alarm that requires that a number of consecutive
data points be breaching to trigger the alarm, this value specifies the
rolling period of time in which data points are evaluated.

Each evaluation period is five minutes long. For example, specify an
evaluation period of 24 to evaluate a metric over a rolling period of
two hours.

You can specify a minimum valuation period of 1 (5 minutes), and a
maximum evaluation period of 288 (24 hours).}

\item{datapointsToAlarm}{The number of data points that must be not within the specified
threshold to trigger the alarm. If you are setting an \"M out of N\"
alarm, this value (\code{datapointsToAlarm}) is the M.}

\item{treatMissingData}{Sets how this alarm will handle missing data points.

An alarm can treat missing data in the following ways:
\itemize{
\item \code{breaching} - Assume the missing data is not within the threshold.
Missing data counts towards the number of times the metric is not
within the threshold.
\item \code{notBreaching} - Assume the missing data is within the threshold.
Missing data does not count towards the number of times the metric
is not within the threshold.
\item \code{ignore} - Ignore the missing data. Maintains the current alarm
state.
\item \code{missing} - Missing data is treated as missing.
}

If \code{treatMissingData} is not specified, the default behavior of
\code{missing} is used.}

\item{contactProtocols}{The contact protocols to use for the alarm, such as \code{Email}, \code{SMS} (text
messaging), or both.

A notification is sent via the specified contact protocol if
notifications are enabled for the alarm, and when the alarm is
triggered.

A notification is not sent if a contact protocol is not specified, if
the specified contact protocol is not configured in the AWS Region, or
if notifications are not enabled for the alarm using the
\code{notificationEnabled} paramater.

Use the \code{CreateContactMethod} action to configure a contact protocol in
an AWS Region.}

\item{notificationTriggers}{The alarm states that trigger a notification.

An alarm has the following possible states:
\itemize{
\item \code{ALARM} - The metric is outside of the defined threshold.
\item \code{INSUFFICIENT_DATA} - The alarm has just started, the metric is not
available, or not enough data is available for the metric to
determine the alarm state.
\item \code{OK} - The metric is within the defined threshold.
}

When you specify a notification trigger, the \code{ALARM} state must be
specified. The \code{INSUFFICIENT_DATA} and \code{OK} states can be specified in
addition to the \code{ALARM} state.
\itemize{
\item If you specify \code{OK} as an alarm trigger, a notification is sent when
the alarm switches from an \code{ALARM} or \code{INSUFFICIENT_DATA} alarm
state to an \code{OK} state. This can be thought of as an \emph{all clear}
alarm notification.
\item If you specify \code{INSUFFICIENT_DATA} as the alarm trigger, a
notification is sent when the alarm switches from an \code{OK} or \code{ALARM}
alarm state to an \code{INSUFFICIENT_DATA} state.
}

The notification trigger defaults to \code{ALARM} if you don\'t specify this
parameter.}

\item{notificationEnabled}{Indicates whether the alarm is enabled.

Notifications are enabled by default if you don\'t specify this
parameter.}
}
\description{
Creates or updates an alarm, and associates it with the specified
metric.
}
\details{
An alarm is used to monitor a single metric for one of your resources.
When a metric condition is met, the alarm can notify you by email, SMS
text message, and a banner displayed on the Amazon Lightsail console.
For more information, see \href{https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms}{Alarms in Amazon Lightsail}.

When this action creates an alarm, the alarm state is immediately set to
\code{INSUFFICIENT_DATA}. The alarm is then evaluated and its state is set
appropriately. Any actions associated with the new state are then
executed.

When you update an existing alarm, its state is left unchanged, but the
update completely overwrites the previous configuration of the alarm.
The alarm is then evaluated with the updated configuration.
}
\section{Request syntax}{
\preformatted{svc$put_alarm(
  alarmName = "string",
  metricName = "CPUUtilization"|"NetworkIn"|"NetworkOut"|"StatusCheckFailed"|"StatusCheckFailed_Instance"|"StatusCheckFailed_System"|"ClientTLSNegotiationErrorCount"|"HealthyHostCount"|"UnhealthyHostCount"|"HTTPCode_LB_4XX_Count"|"HTTPCode_LB_5XX_Count"|"HTTPCode_Instance_2XX_Count"|"HTTPCode_Instance_3XX_Count"|"HTTPCode_Instance_4XX_Count"|"HTTPCode_Instance_5XX_Count"|"InstanceResponseTime"|"RejectedConnectionCount"|"RequestCount"|"DatabaseConnections"|"DiskQueueDepth"|"FreeStorageSpace"|"NetworkReceiveThroughput"|"NetworkTransmitThroughput"|"BurstCapacityTime"|"BurstCapacityPercentage",
  monitoredResourceName = "string",
  comparisonOperator = "GreaterThanOrEqualToThreshold"|"GreaterThanThreshold"|"LessThanThreshold"|"LessThanOrEqualToThreshold",
  threshold = 123.0,
  evaluationPeriods = 123,
  datapointsToAlarm = 123,
  treatMissingData = "breaching"|"notBreaching"|"ignore"|"missing",
  contactProtocols = list(
    "Email"|"SMS"
  ),
  notificationTriggers = list(
    "OK"|"ALARM"|"INSUFFICIENT_DATA"
  ),
  notificationEnabled = TRUE|FALSE
)
}
}

\keyword{internal}
