% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_default_credit_specification}
\alias{ec2_modify_default_credit_specification}
\title{Modifies the default credit option for CPU usage of burstable
performance instances}
\usage{
ec2_modify_default_credit_specification(DryRun, InstanceFamily,
  CpuCredits)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceFamily}{[required] The instance family.}

\item{CpuCredits}{[required] The credit option for CPU usage of the instance family.

Valid Values: \code{standard} \\| \code{unlimited}}
}
\description{
Modifies the default credit option for CPU usage of burstable
performance instances. The default credit option is set at the account
level per AWS Region, and is specified per instance family. All new
burstable performance instances in the account launch using the default
credit option.
}
\details{
\code{ModifyDefaultCreditSpecification} is an asynchronous operation, which
works at an AWS Region level and modifies the credit option for each
Availability Zone. All zones in a Region are updated within five
minutes. But if instances are launched during this operation, they might
not get the new credit option until the zone is updated. To verify
whether the update has occurred, you can call
\code{GetDefaultCreditSpecification} and check \code{DefaultCreditSpecification}
for updates.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html}{Burstable performance instances}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$modify_default_credit_specification(
  DryRun = TRUE|FALSE,
  InstanceFamily = "t2"|"t3"|"t3a",
  CpuCredits = "string"
)
}
}

\keyword{internal}
