% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_put_image_scanning_configuration}
\alias{ecr_put_image_scanning_configuration}
\title{Updates the image scanning configuration for a repository}
\usage{
ecr_put_image_scanning_configuration(registryId, repositoryName,
  imageScanningConfiguration)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the
repository in which to update the image scanning configuration setting.
If you do not specify a registry, the default registry is assumed.}

\item{repositoryName}{[required] The name of the repository in which to update the image scanning
configuration setting.}

\item{imageScanningConfiguration}{[required] The image scanning configuration for the repository. This setting
determines whether images are scanned for known vulnerabilities after
being pushed to the repository.}
}
\description{
Updates the image scanning configuration for a repository.
}
\section{Request syntax}{
\preformatted{svc$put_image_scanning_configuration(
  registryId = "string",
  repositoryName = "string",
  imageScanningConfiguration = list(
    scanOnPush = TRUE|FALSE
  )
)
}
}

\keyword{internal}
