% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_reserved_instances_offerings}
\alias{ec2_describe_reserved_instances_offerings}
\title{Describes Reserved Instance offerings that are available for purchase}
\usage{
ec2_describe_reserved_instances_offerings(AvailabilityZone, Filters,
  IncludeMarketplace, InstanceType, MaxDuration, MaxInstanceCount,
  MinDuration, OfferingClass, ProductDescription,
  ReservedInstancesOfferingIds, DryRun, InstanceTenancy, MaxResults,
  NextToken, OfferingType)
}
\arguments{
\item{AvailabilityZone}{The Availability Zone in which the Reserved Instance can be used.}

\item{Filters}{One or more filters.
\itemize{
\item \code{availability-zone} - The Availability Zone where the Reserved
Instance can be used.
\item \code{duration} - The duration of the Reserved Instance (for example, one
year or three years), in seconds (\code{31536000} \\| \code{94608000}).
\item \code{fixed-price} - The purchase price of the Reserved Instance (for
example, 9800.0).
\item \code{instance-type} - The instance type that is covered by the
reservation.
\item \code{marketplace} - Set to \code{true} to show only Reserved Instance
Marketplace offerings. When this filter is not used, which is the
default behavior, all offerings from both AWS and the Reserved
Instance Marketplace are listed.
\item \code{product-description} - The Reserved Instance product platform
description. Instances that include \verb{(Amazon VPC)} in the product
platform description will only be displayed to EC2-Classic account
holders and are for use with Amazon VPC. (\code{Linux/UNIX} \\|
\verb{Linux/UNIX (Amazon VPC)} \\| \verb{SUSE Linux} \\|
\verb{SUSE Linux (Amazon VPC)} \\| \verb{Red Hat Enterprise Linux} \\|
\verb{Red Hat Enterprise Linux (Amazon VPC)} \\| \code{Windows} \\|
\verb{Windows (Amazon VPC)} \\| \verb{Windows with SQL Server Standard} \\|
\verb{Windows with SQL Server Standard (Amazon VPC)} \\|
\verb{Windows with SQL Server Web} \\|
\verb{ Windows with SQL Server Web (Amazon VPC)} \\|
\verb{Windows with SQL Server Enterprise} \\|
\verb{Windows with SQL Server Enterprise (Amazon VPC)})
\item \code{reserved-instances-offering-id} - The Reserved Instances offering
ID.
\item \code{scope} - The scope of the Reserved Instance (\verb{Availability Zone} or
\code{Region}).
\item \code{usage-price} - The usage price of the Reserved Instance, per hour
(for example, 0.84).
}}

\item{IncludeMarketplace}{Include Reserved Instance Marketplace offerings in the response.}

\item{InstanceType}{The instance type that the reservation will cover (for example,
\code{m1.small}). For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html}{Instance Types}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{MaxDuration}{The maximum duration (in seconds) to filter when searching for
offerings.

Default: 94608000 (3 years)}

\item{MaxInstanceCount}{The maximum number of instances to filter when searching for offerings.

Default: 20}

\item{MinDuration}{The minimum duration (in seconds) to filter when searching for
offerings.

Default: 2592000 (1 month)}

\item{OfferingClass}{The offering class of the Reserved Instance. Can be \code{standard} or
\code{convertible}.}

\item{ProductDescription}{The Reserved Instance product platform description. Instances that
include \verb{(Amazon VPC)} in the description are for use with Amazon VPC.}

\item{ReservedInstancesOfferingIds}{One or more Reserved Instances offering IDs.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceTenancy}{The tenancy of the instances covered by the reservation. A Reserved
Instance with a tenancy of \code{dedicated} is applied to instances that run
in a VPC on single-tenant hardware (i.e., Dedicated Instances).

\strong{Important:} The \code{host} value cannot be used with this parameter. Use
the \code{default} or \code{dedicated} values only.

Default: \code{default}}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results of the initial request can be seen by
sending another request with the returned \code{NextToken} value. The maximum
is 100.

Default: 100}

\item{NextToken}{The token to retrieve the next page of results.}

\item{OfferingType}{The Reserved Instance offering type. If you are using tools that predate
the 2011-11-01 API version, you only have access to the
\verb{Medium Utilization} Reserved Instance offering type.}
}
\description{
Describes Reserved Instance offerings that are available for purchase.
With Reserved Instances, you purchase the right to launch instances for
a period of time. During that time period, you do not receive
insufficient capacity errors, and you pay a lower usage rate than the
rate charged for On-Demand instances for the actual time used.
}
\details{
If you have listed your own Reserved Instances for sale in the Reserved
Instance Marketplace, they will be excluded from these results. This is
to ensure that you do not purchase your own Reserved Instances.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html}{Reserved Instance Marketplace}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_reserved_instances_offerings(
  AvailabilityZone = "string",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  IncludeMarketplace = TRUE|FALSE,
  InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge",
  MaxDuration = 123,
  MaxInstanceCount = 123,
  MinDuration = 123,
  OfferingClass = "standard"|"convertible",
  ProductDescription = "Linux/UNIX"|"Linux/UNIX (Amazon VPC)"|"Windows"|"Windows (Amazon VPC)",
  ReservedInstancesOfferingIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE,
  InstanceTenancy = "default"|"dedicated"|"host",
  MaxResults = 123,
  NextToken = "string",
  OfferingType = "Heavy Utilization"|"Medium Utilization"|"Light Utilization"|"No Upfront"|"Partial Upfront"|"All Upfront"
)
}
}

\keyword{internal}
