% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_vpc_endpoint_service_configurations}
\alias{ec2_delete_vpc_endpoint_service_configurations}
\title{Deletes one or more VPC endpoint service configurations in your account}
\usage{
ec2_delete_vpc_endpoint_service_configurations(DryRun, ServiceIds)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ServiceIds}{[required] The IDs of one or more services.}
}
\description{
Deletes one or more VPC endpoint service configurations in your account.
Before you delete the endpoint service configuration, you must reject
any \code{Available} or \code{PendingAcceptance} interface endpoint connections
that are attached to the service.
}
\section{Request syntax}{
\preformatted{svc$delete_vpc_endpoint_service_configurations(
  DryRun = TRUE|FALSE,
  ServiceIds = list(
    "string"
  )
)
}
}

\keyword{internal}
