% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_create_task_set}
\alias{ecs_create_task_set}
\title{Create a task set in the specified cluster and service}
\usage{
ecs_create_task_set(service, cluster, externalId, taskDefinition,
  networkConfiguration, loadBalancers, serviceRegistries, launchType,
  capacityProviderStrategy, platformVersion, scale, clientToken)
}
\arguments{
\item{service}{[required] The short name or full Amazon Resource Name (ARN) of the service to
create the task set in.}

\item{cluster}{[required] The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the service to create the task set in.}

\item{externalId}{An optional non-unique tag that identifies this task set in external
systems. If the task set is associated with a service discovery
registry, the tasks in this task set will have the
\code{ECS_TASK_SET_EXTERNAL_ID} AWS Cloud Map attribute set to the provided
value.}

\item{taskDefinition}{[required] The task definition for the tasks in the task set to use.}

\item{networkConfiguration}{}

\item{loadBalancers}{A load balancer object representing the load balancer to use with the
task set. The supported load balancer types are either an Application
Load Balancer or a Network Load Balancer.}

\item{serviceRegistries}{The details of the service discovery registries to assign to this task
set. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html}{Service Discovery}.}

\item{launchType}{The launch type that new tasks in the task set will use. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html}{Amazon ECS Launch Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.

If a \code{launchType} is specified, the \code{capacityProviderStrategy} parameter
must be omitted.}

\item{capacityProviderStrategy}{The capacity provider strategy to use for the task set.

A capacity provider strategy consists of one or more capacity providers
along with the \code{base} and \code{weight} to assign to them. A capacity
provider must be associated with the cluster to be used in a capacity
provider strategy. The PutClusterCapacityProviders API is used to
associate a capacity provider with a cluster. Only capacity providers
with an \code{ACTIVE} or \code{UPDATING} status can be used.

If a \code{capacityProviderStrategy} is specified, the \code{launchType} parameter
must be omitted. If no \code{capacityProviderStrategy} or \code{launchType} is
specified, the \code{defaultCapacityProviderStrategy} for the cluster is
used.

If specifying a capacity provider that uses an Auto Scaling group, the
capacity provider must already be created. New capacity providers can be
created with the CreateCapacityProvider API operation.

To use a AWS Fargate capacity provider, specify either the \code{FARGATE} or
\code{FARGATE_SPOT} capacity providers. The AWS Fargate capacity providers
are available to all accounts and only need to be associated with a
cluster to be used.

The PutClusterCapacityProviders API operation is used to update the list
of available capacity providers for a cluster after the cluster is
created.}

\item{platformVersion}{The platform version that the tasks in the task set should use. A
platform version is specified only for tasks using the Fargate launch
type. If one isn\'t specified, the \code{LATEST} platform version is used by
default.}

\item{scale}{}

\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 32 ASCII characters are allowed.}
}
\description{
Create a task set in the specified cluster and service. This is used
when a service uses the \code{EXTERNAL} deployment controller type. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html}{Amazon ECS Deployment Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_task_set(
  service = "string",
  cluster = "string",
  externalId = "string",
  taskDefinition = "string",
  networkConfiguration = list(
    awsvpcConfiguration = list(
      subnets = list(
        "string"
      ),
      securityGroups = list(
        "string"
      ),
      assignPublicIp = "ENABLED"|"DISABLED"
    )
  ),
  loadBalancers = list(
    list(
      targetGroupArn = "string",
      loadBalancerName = "string",
      containerName = "string",
      containerPort = 123
    )
  ),
  serviceRegistries = list(
    list(
      registryArn = "string",
      port = 123,
      containerName = "string",
      containerPort = 123
    )
  ),
  launchType = "EC2"|"FARGATE",
  capacityProviderStrategy = list(
    list(
      capacityProvider = "string",
      weight = 123,
      base = 123
    )
  ),
  platformVersion = "string",
  scale = list(
    value = 123.0,
    unit = "PERCENT"
  ),
  clientToken = "string"
)
}
}

\keyword{internal}
