% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_tags}
\alias{ec2_describe_tags}
\title{Describes the specified tags for your EC2 resources}
\usage{
ec2_describe_tags(DryRun, Filters, MaxResults, NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Filters}{The filters.
\itemize{
\item \code{key} - The tag key.
\item \code{resource-id} - The ID of the resource.
\item \code{resource-type} - The resource type (\code{customer-gateway} \\|
\code{dedicated-host} \\| \code{dhcp-options} \\| \code{elastic-ip} \\| \code{fleet} \\|
\code{fpga-image} \\| \code{image} \\| \code{instance} \\| \code{host-reservation} \\|
\code{internet-gateway} \\| \code{launch-template} \\| \code{natgateway} \\|
\code{network-acl} \\| \code{network-interface} \\| \code{reserved-instances} \\|
\code{route-table} \\| \code{security-group} \\| \code{snapshot} \\|
\code{spot-instances-request} \\| \code{subnet} \\| \code{volume} \\| \code{vpc} \\|
\code{vpc-peering-connection} \\| \code{vpn-connection} \\| \code{vpn-gateway}).
\item \code{tag}:\\<key\\> - The key/value combination of the tag. For example,
specify \"tag:Owner\" for the filter name and \"TeamA\" for the
filter value to find resources with the tag \"Owner=TeamA\".
\item \code{value} - The tag value.
}}

\item{MaxResults}{The maximum number of results to return in a single call. This value can
be between 5 and 1000. To retrieve the remaining results, make another
call with the returned \code{NextToken} value.}

\item{NextToken}{The token to retrieve the next page of results.}
}
\description{
Describes the specified tags for your EC2 resources.
}
\details{
For more information about tags, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html}{Tagging Your Resources}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_tags(
  DryRun = TRUE|FALSE,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\examples{
# This example describes the tags for the specified instance.
\donttest{svc$describe_tags(
  Filters = list(
    list(
      Name = "resource-id",
      Values = list(
        "i-1234567890abcdef8"
      )
    )
  )
)}

}
\keyword{internal}
