% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_attach_internet_gateway}
\alias{ec2_attach_internet_gateway}
\title{Attaches an internet gateway or a virtual private gateway to a VPC,
enabling connectivity between the internet and the VPC}
\usage{
ec2_attach_internet_gateway(DryRun, InternetGatewayId, VpcId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InternetGatewayId}{[required] The ID of the internet gateway.}

\item{VpcId}{[required] The ID of the VPC.}
}
\description{
Attaches an internet gateway or a virtual private gateway to a VPC,
enabling connectivity between the internet and the VPC. For more
information about your VPC and internet gateway, see the \href{https://docs.aws.amazon.com/vpc/latest/userguide/}{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$attach_internet_gateway(
  DryRun = TRUE|FALSE,
  InternetGatewayId = "string",
  VpcId = "string"
)
}
}

\examples{
# This example attaches the specified Internet gateway to the specified
# VPC.
\donttest{svc$attach_internet_gateway(
  InternetGatewayId = "igw-c0a643a9",
  VpcId = "vpc-a01106c2"
)}

}
\keyword{internal}
