# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include elasticbeanstalk_service.R
NULL

#' Cancels in-progress environment configuration update or application
#' version deployment
#'
#' Cancels in-progress environment configuration update or application
#' version deployment.
#'
#' @usage
#' elasticbeanstalk_abort_environment_update(EnvironmentId,
#'   EnvironmentName)
#'
#' @param EnvironmentId This specifies the ID of the environment with the in-progress update
#' that you want to cancel.
#' @param EnvironmentName This specifies the name of the environment with the in-progress update
#' that you want to cancel.
#'
#' @section Request syntax:
#' ```
#' svc$abort_environment_update(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' # The following code aborts a running application version deployment for
#' # an environment named my-env:
#' \donttest{svc$abort_environment_update(
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_abort_environment_update
elasticbeanstalk_abort_environment_update <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "AbortEnvironmentUpdate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$abort_environment_update_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$abort_environment_update_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$abort_environment_update <- elasticbeanstalk_abort_environment_update

#' Applies a scheduled managed action immediately
#'
#' Applies a scheduled managed action immediately. A managed action can be
#' applied only if its status is `Scheduled`. Get the status and action ID
#' of a managed action with DescribeEnvironmentManagedActions.
#'
#' @usage
#' elasticbeanstalk_apply_environment_managed_action(EnvironmentName,
#'   EnvironmentId, ActionId)
#'
#' @param EnvironmentName The name of the target environment.
#' @param EnvironmentId The environment ID of the target environment.
#' @param ActionId &#91;required&#93; The action ID of the scheduled managed action to execute.
#'
#' @section Request syntax:
#' ```
#' svc$apply_environment_managed_action(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   ActionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_apply_environment_managed_action
elasticbeanstalk_apply_environment_managed_action <- function(EnvironmentName = NULL, EnvironmentId = NULL, ActionId) {
  op <- new_operation(
    name = "ApplyEnvironmentManagedAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$apply_environment_managed_action_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, ActionId = ActionId)
  output <- .elasticbeanstalk$apply_environment_managed_action_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$apply_environment_managed_action <- elasticbeanstalk_apply_environment_managed_action

#' Checks if the specified CNAME is available
#'
#' Checks if the specified CNAME is available.
#'
#' @usage
#' elasticbeanstalk_check_dns_availability(CNAMEPrefix)
#'
#' @param CNAMEPrefix &#91;required&#93; The prefix used when this CNAME is reserved.
#'
#' @section Request syntax:
#' ```
#' svc$check_dns_availability(
#'   CNAMEPrefix = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation checks the availability of the subdomain
#' # my-cname:
#' \donttest{svc$check_dns_availability(
#'   CNAMEPrefix = "my-cname"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_check_dns_availability
elasticbeanstalk_check_dns_availability <- function(CNAMEPrefix) {
  op <- new_operation(
    name = "CheckDNSAvailability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$check_dns_availability_input(CNAMEPrefix = CNAMEPrefix)
  output <- .elasticbeanstalk$check_dns_availability_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$check_dns_availability <- elasticbeanstalk_check_dns_availability

#' Create or update a group of environments that each run a separate
#' component of a single application
#'
#' Create or update a group of environments that each run a separate
#' component of a single application. Takes a list of version labels that
#' specify application source bundles for each of the environments to
#' create or update. The name of each environment and other required
#' information must be included in the source bundles in an environment
#' manifest named `env.yaml`. See [Compose
#' Environments](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html)
#' for details.
#'
#' @usage
#' elasticbeanstalk_compose_environments(ApplicationName, GroupName,
#'   VersionLabels)
#'
#' @param ApplicationName The name of the application to which the specified source bundles
#' belong.
#' @param GroupName The name of the group to which the target environments belong. Specify a
#' group name only if the environment name defined in each target
#' environment\'s manifest ends with a + (plus) character. See [Environment
#' Manifest
#' (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
#' for details.
#' @param VersionLabels A list of version labels, specifying one or more application source
#' bundles that belong to the target application. Each source bundle must
#' include an environment manifest that specifies the name of the
#' environment and the name of the solution stack to use, and optionally
#' can specify environment links to create.
#'
#' @section Request syntax:
#' ```
#' svc$compose_environments(
#'   ApplicationName = "string",
#'   GroupName = "string",
#'   VersionLabels = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_compose_environments
elasticbeanstalk_compose_environments <- function(ApplicationName = NULL, GroupName = NULL, VersionLabels = NULL) {
  op <- new_operation(
    name = "ComposeEnvironments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$compose_environments_input(ApplicationName = ApplicationName, GroupName = GroupName, VersionLabels = VersionLabels)
  output <- .elasticbeanstalk$compose_environments_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$compose_environments <- elasticbeanstalk_compose_environments

#' Creates an application that has one configuration template named default
#' and no application versions
#'
#' Creates an application that has one configuration template named
#' `default` and no application versions.
#'
#' @usage
#' elasticbeanstalk_create_application(ApplicationName, Description,
#'   ResourceLifecycleConfig, Tags)
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' 
#' Constraint: This name must be unique within your account. If the
#' specified name already exists, the action returns an
#' `InvalidParameterValue` error.
#' @param Description Describes the application.
#' @param ResourceLifecycleConfig Specify an application resource lifecycle configuration to prevent your
#' application from accumulating too many versions.
#' @param Tags Specifies the tags applied to the application.
#' 
#' Elastic Beanstalk applies these tags only to the application.
#' Environments that you create in the application don\'t inherit the tags.
#'
#' @section Request syntax:
#' ```
#' svc$create_application(
#'   ApplicationName = "string",
#'   Description = "string",
#'   ResourceLifecycleConfig = list(
#'     ServiceRole = "string",
#'     VersionLifecycleConfig = list(
#'       MaxCountRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxCount = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       ),
#'       MaxAgeRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxAgeInDays = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation creates a new application named my-app:
#' \donttest{svc$create_application(
#'   ApplicationName = "my-app",
#'   Description = "my application"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_application
elasticbeanstalk_create_application <- function(ApplicationName, Description = NULL, ResourceLifecycleConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_application_input(ApplicationName = ApplicationName, Description = Description, ResourceLifecycleConfig = ResourceLifecycleConfig, Tags = Tags)
  output <- .elasticbeanstalk$create_application_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_application <- elasticbeanstalk_create_application

#' Creates an application version for the specified application
#'
#' Creates an application version for the specified application. You can
#' create an application version from a source bundle in Amazon S3, a
#' commit in AWS CodeCommit, or the output of an AWS CodeBuild build as
#' follows:
#' 
#' Specify a commit in an AWS CodeCommit repository with
#' `SourceBuildInformation`.
#' 
#' Specify a build in an AWS CodeBuild with `SourceBuildInformation` and
#' `BuildConfiguration`.
#' 
#' Specify a source bundle in S3 with `SourceBundle`
#' 
#' Omit both `SourceBuildInformation` and `SourceBundle` to use the default
#' sample application.
#' 
#' Once you create an application version with a specified Amazon S3 bucket
#' and key location, you cannot change that Amazon S3 location. If you
#' change the Amazon S3 location, you receive an exception when you attempt
#' to launch an environment from the application version.
#'
#' @usage
#' elasticbeanstalk_create_application_version(ApplicationName,
#'   VersionLabel, Description, SourceBuildInformation, SourceBundle,
#'   BuildConfiguration, AutoCreateApplication, Process, Tags)
#'
#' @param ApplicationName &#91;required&#93; The name of the application. If no application is found with this name,
#' and `AutoCreateApplication` is `false`, returns an
#' `InvalidParameterValue` error.
#' @param VersionLabel &#91;required&#93; A label identifying this version.
#' 
#' Constraint: Must be unique per application. If an application version
#' already exists with this label for the specified application, AWS
#' Elastic Beanstalk returns an `InvalidParameterValue` error.
#' @param Description Describes this version.
#' @param SourceBuildInformation Specify a commit in an AWS CodeCommit Git repository to use as the
#' source code for the application version.
#' @param SourceBundle The Amazon S3 bucket and key that identify the location of the source
#' bundle for this version.
#' 
#' The Amazon S3 bucket must be in the same region as the environment.
#' 
#' Specify a source bundle in S3 or a commit in an AWS CodeCommit
#' repository (with `SourceBuildInformation`), but not both. If neither
#' `SourceBundle` nor `SourceBuildInformation` are provided, Elastic
#' Beanstalk uses a sample application.
#' @param BuildConfiguration Settings for an AWS CodeBuild build.
#' @param AutoCreateApplication Set to `true` to create an application with the specified name if it
#' doesn\'t already exist.
#' @param Process Pre-processes and validates the environment manifest (`env.yaml`) and
#' configuration files (`*.config` files in the `.ebextensions` folder) in
#' the source bundle. Validating configuration files can identify issues
#' prior to deploying the application version to an environment.
#' 
#' You must turn processing on for application versions that you create
#' using AWS CodeBuild or AWS CodeCommit. For application versions built
#' from a source bundle in Amazon S3, processing is optional.
#' 
#' The `Process` option validates Elastic Beanstalk configuration files. It
#' doesn\'t validate your application\'s configuration files, like proxy
#' server or Docker configuration.
#' @param Tags Specifies the tags applied to the application version.
#' 
#' Elastic Beanstalk applies these tags only to the application version.
#' Environments that use the application version don\'t inherit the tags.
#'
#' @section Request syntax:
#' ```
#' svc$create_application_version(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   Description = "string",
#'   SourceBuildInformation = list(
#'     SourceType = "Git"|"Zip",
#'     SourceRepository = "CodeCommit"|"S3",
#'     SourceLocation = "string"
#'   ),
#'   SourceBundle = list(
#'     S3Bucket = "string",
#'     S3Key = "string"
#'   ),
#'   BuildConfiguration = list(
#'     ArtifactName = "string",
#'     CodeBuildServiceRole = "string",
#'     ComputeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE",
#'     Image = "string",
#'     TimeoutInMinutes = 123
#'   ),
#'   AutoCreateApplication = TRUE|FALSE,
#'   Process = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation creates a new version (v1) of an application
#' # named my-app:
#' \donttest{svc$create_application_version(
#'   ApplicationName = "my-app",
#'   AutoCreateApplication = TRUE,
#'   Description = "my-app-v1",
#'   Process = TRUE,
#'   SourceBundle = list(
#'     S3Bucket = "my-bucket",
#'     S3Key = "sample.war"
#'   ),
#'   VersionLabel = "v1"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_application_version
elasticbeanstalk_create_application_version <- function(ApplicationName, VersionLabel, Description = NULL, SourceBuildInformation = NULL, SourceBundle = NULL, BuildConfiguration = NULL, AutoCreateApplication = NULL, Process = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplicationVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_application_version_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, Description = Description, SourceBuildInformation = SourceBuildInformation, SourceBundle = SourceBundle, BuildConfiguration = BuildConfiguration, AutoCreateApplication = AutoCreateApplication, Process = Process, Tags = Tags)
  output <- .elasticbeanstalk$create_application_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_application_version <- elasticbeanstalk_create_application_version

#' Creates a configuration template
#'
#' Creates a configuration template. Templates are associated with a
#' specific application and are used to deploy different versions of the
#' application with the same configuration settings.
#' 
#' Templates aren\'t associated with any environment. The `EnvironmentName`
#' response element is always `null`.
#' 
#' Related Topics
#' 
#' -   DescribeConfigurationOptions
#' 
#' -   DescribeConfigurationSettings
#' 
#' -   ListAvailableSolutionStacks
#'
#' @usage
#' elasticbeanstalk_create_configuration_template(ApplicationName,
#'   TemplateName, SolutionStackName, PlatformArn, SourceConfiguration,
#'   EnvironmentId, Description, OptionSettings, Tags)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to associate with this configuration
#' template. If no application is found with this name, AWS Elastic
#' Beanstalk returns an `InvalidParameterValue` error.
#' @param TemplateName &#91;required&#93; The name of the configuration template.
#' 
#' Constraint: This name must be unique per application.
#' 
#' Default: If a configuration template already exists with this name, AWS
#' Elastic Beanstalk returns an `InvalidParameterValue` error.
#' @param SolutionStackName The name of the solution stack used by this configuration. The solution
#' stack specifies the operating system, architecture, and application
#' server for a configuration template. It determines the set of
#' configuration options as well as the possible and default values.
#' 
#' Use ListAvailableSolutionStacks to obtain a list of available solution
#' stacks.
#' 
#' A solution stack name or a source configuration parameter must be
#' specified, otherwise AWS Elastic Beanstalk returns an
#' `InvalidParameterValue` error.
#' 
#' If a solution stack name is not specified and the source configuration
#' parameter is specified, AWS Elastic Beanstalk uses the same solution
#' stack as the source configuration template.
#' @param PlatformArn The ARN of the custom platform.
#' @param SourceConfiguration If specified, AWS Elastic Beanstalk uses the configuration values from
#' the specified configuration template to create a new configuration.
#' 
#' Values specified in the `OptionSettings` parameter of this call
#' overrides any values obtained from the `SourceConfiguration`.
#' 
#' If no configuration template is found, returns an
#' `InvalidParameterValue` error.
#' 
#' Constraint: If both the solution stack name parameter and the source
#' configuration parameters are specified, the solution stack of the source
#' configuration template must match the specified solution stack name or
#' else AWS Elastic Beanstalk returns an `InvalidParameterCombination`
#' error.
#' @param EnvironmentId The ID of the environment used with this configuration template.
#' @param Description Describes this configuration.
#' @param OptionSettings If specified, AWS Elastic Beanstalk sets the specified configuration
#' option to the requested value. The new value overrides the value
#' obtained from the solution stack or the source configuration template.
#' @param Tags Specifies the tags applied to the configuration template.
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration_template(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   SourceConfiguration = list(
#'     ApplicationName = "string",
#'     TemplateName = "string"
#'   ),
#'   EnvironmentId = "string",
#'   Description = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation creates a configuration template named my-app-v1
#' # from the settings applied to an environment with the id e-rpqsewtp2j:
#' \donttest{svc$create_configuration_template(
#'   ApplicationName = "my-app",
#'   EnvironmentId = "e-rpqsewtp2j",
#'   TemplateName = "my-app-v1"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_configuration_template
elasticbeanstalk_create_configuration_template <- function(ApplicationName, TemplateName, SolutionStackName = NULL, PlatformArn = NULL, SourceConfiguration = NULL, EnvironmentId = NULL, Description = NULL, OptionSettings = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateConfigurationTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_configuration_template_input(ApplicationName = ApplicationName, TemplateName = TemplateName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, SourceConfiguration = SourceConfiguration, EnvironmentId = EnvironmentId, Description = Description, OptionSettings = OptionSettings, Tags = Tags)
  output <- .elasticbeanstalk$create_configuration_template_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_configuration_template <- elasticbeanstalk_create_configuration_template

#' Launches an environment for the specified application using the
#' specified configuration
#'
#' Launches an environment for the specified application using the
#' specified configuration.
#'
#' @usage
#' elasticbeanstalk_create_environment(ApplicationName, EnvironmentName,
#'   GroupName, Description, CNAMEPrefix, Tier, Tags, VersionLabel,
#'   TemplateName, SolutionStackName, PlatformArn, OptionSettings,
#'   OptionsToRemove)
#'
#' @param ApplicationName &#91;required&#93; The name of the application that contains the version to be deployed.
#' 
#' If no application is found with this name, `CreateEnvironment` returns
#' an `InvalidParameterValue` error.
#' @param EnvironmentName A unique name for the deployment environment. Used in the application
#' URL.
#' 
#' Constraint: Must be from 4 to 40 characters in length. The name can
#' contain only letters, numbers, and hyphens. It cannot start or end with
#' a hyphen. This name must be unique within a region in your account. If
#' the specified name already exists in the region, AWS Elastic Beanstalk
#' returns an `InvalidParameterValue` error.
#' 
#' Default: If the CNAME parameter is not specified, the environment name
#' becomes part of the CNAME, and therefore part of the visible URL for
#' your application.
#' @param GroupName The name of the group to which the target environment belongs. Specify a
#' group name only if the environment\'s name is specified in an
#' environment manifest and not with the environment name parameter. See
#' [Environment Manifest
#' (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
#' for details.
#' @param Description Describes this environment.
#' @param CNAMEPrefix If specified, the environment attempts to use this value as the prefix
#' for the CNAME. If not specified, the CNAME is generated automatically by
#' appending a random alphanumeric string to the environment name.
#' @param Tier This specifies the tier to use for creating this environment.
#' @param Tags Specifies the tags applied to resources in the environment.
#' @param VersionLabel The name of the application version to deploy.
#' 
#' If the specified application has no associated application versions, AWS
#' Elastic Beanstalk `UpdateEnvironment` returns an `InvalidParameterValue`
#' error.
#' 
#' Default: If not specified, AWS Elastic Beanstalk attempts to launch the
#' sample application in the container.
#' @param TemplateName The name of the configuration template to use in deployment. If no
#' configuration template is found with this name, AWS Elastic Beanstalk
#' returns an `InvalidParameterValue` error.
#' @param SolutionStackName This is an alternative to specifying a template name. If specified, AWS
#' Elastic Beanstalk sets the configuration values to the default values
#' associated with the specified solution stack.
#' 
#' For a list of current solution stacks, see [Elastic Beanstalk Supported
#' Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html).
#' @param PlatformArn The ARN of the platform.
#' @param OptionSettings If specified, AWS Elastic Beanstalk sets the specified configuration
#' options to the requested value in the configuration set for the new
#' environment. These override the values obtained from the solution stack
#' or the configuration template.
#' @param OptionsToRemove A list of custom user-defined configuration options to remove from the
#' configuration set for this new environment.
#'
#' @section Request syntax:
#' ```
#' svc$create_environment(
#'   ApplicationName = "string",
#'   EnvironmentName = "string",
#'   GroupName = "string",
#'   Description = "string",
#'   CNAMEPrefix = "string",
#'   Tier = list(
#'     Name = "string",
#'     Type = "string",
#'     Version = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   VersionLabel = "string",
#'   TemplateName = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   OptionsToRemove = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation creates a new environment for version v1 of a
#' # java application named my-app:
#' \donttest{svc$create_environment(
#'   ApplicationName = "my-app",
#'   CNAMEPrefix = "my-app",
#'   EnvironmentName = "my-env",
#'   SolutionStackName = "64bit Amazon Linux 2015.03 v2.0.0 running Tomcat 8 Java 8",
#'   VersionLabel = "v1"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_environment
elasticbeanstalk_create_environment <- function(ApplicationName, EnvironmentName = NULL, GroupName = NULL, Description = NULL, CNAMEPrefix = NULL, Tier = NULL, Tags = NULL, VersionLabel = NULL, TemplateName = NULL, SolutionStackName = NULL, PlatformArn = NULL, OptionSettings = NULL, OptionsToRemove = NULL) {
  op <- new_operation(
    name = "CreateEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_environment_input(ApplicationName = ApplicationName, EnvironmentName = EnvironmentName, GroupName = GroupName, Description = Description, CNAMEPrefix = CNAMEPrefix, Tier = Tier, Tags = Tags, VersionLabel = VersionLabel, TemplateName = TemplateName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, OptionSettings = OptionSettings, OptionsToRemove = OptionsToRemove)
  output <- .elasticbeanstalk$create_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_environment <- elasticbeanstalk_create_environment

#' Create a new version of your custom platform
#'
#' Create a new version of your custom platform.
#'
#' @usage
#' elasticbeanstalk_create_platform_version(PlatformName, PlatformVersion,
#'   PlatformDefinitionBundle, EnvironmentName, OptionSettings, Tags)
#'
#' @param PlatformName &#91;required&#93; The name of your custom platform.
#' @param PlatformVersion &#91;required&#93; The number, such as 1.0.2, for the new platform version.
#' @param PlatformDefinitionBundle &#91;required&#93; The location of the platform definition archive in Amazon S3.
#' @param EnvironmentName The name of the builder environment.
#' @param OptionSettings The configuration option settings to apply to the builder environment.
#' @param Tags Specifies the tags applied to the new platform version.
#' 
#' Elastic Beanstalk applies these tags only to the platform version.
#' Environments that you create using the platform version don\'t inherit
#' the tags.
#'
#' @section Request syntax:
#' ```
#' svc$create_platform_version(
#'   PlatformName = "string",
#'   PlatformVersion = "string",
#'   PlatformDefinitionBundle = list(
#'     S3Bucket = "string",
#'     S3Key = "string"
#'   ),
#'   EnvironmentName = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_platform_version
elasticbeanstalk_create_platform_version <- function(PlatformName, PlatformVersion, PlatformDefinitionBundle, EnvironmentName = NULL, OptionSettings = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePlatformVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_platform_version_input(PlatformName = PlatformName, PlatformVersion = PlatformVersion, PlatformDefinitionBundle = PlatformDefinitionBundle, EnvironmentName = EnvironmentName, OptionSettings = OptionSettings, Tags = Tags)
  output <- .elasticbeanstalk$create_platform_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_platform_version <- elasticbeanstalk_create_platform_version

#' Creates a bucket in Amazon S3 to store application versions, logs, and
#' other files used by Elastic Beanstalk environments
#'
#' Creates a bucket in Amazon S3 to store application versions, logs, and
#' other files used by Elastic Beanstalk environments. The Elastic
#' Beanstalk console and EB CLI call this API the first time you create an
#' environment in a region. If the storage location already exists,
#' `CreateStorageLocation` still returns the bucket name but does not
#' create a new bucket.
#'
#' @usage
#' elasticbeanstalk_create_storage_location()
#'

#'

#'
#' @examples
#' # The following operation creates a new environment for version v1 of a
#' # java application named my-app:
#' \donttest{svc$create_storage_location()}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_storage_location
elasticbeanstalk_create_storage_location <- function() {
  op <- new_operation(
    name = "CreateStorageLocation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_storage_location_input()
  output <- .elasticbeanstalk$create_storage_location_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_storage_location <- elasticbeanstalk_create_storage_location

#' Deletes the specified application along with all associated versions and
#' configurations
#'
#' Deletes the specified application along with all associated versions and
#' configurations. The application versions will not be deleted from your
#' Amazon S3 bucket.
#' 
#' You cannot delete an application that has a running environment.
#'
#' @usage
#' elasticbeanstalk_delete_application(ApplicationName,
#'   TerminateEnvByForce)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to delete.
#' @param TerminateEnvByForce When set to true, running environments will be terminated before
#' deleting the application.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application(
#'   ApplicationName = "string",
#'   TerminateEnvByForce = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following operation deletes an application named my-app:
#' \donttest{svc$delete_application(
#'   ApplicationName = "my-app"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_application
elasticbeanstalk_delete_application <- function(ApplicationName, TerminateEnvByForce = NULL) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_application_input(ApplicationName = ApplicationName, TerminateEnvByForce = TerminateEnvByForce)
  output <- .elasticbeanstalk$delete_application_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_application <- elasticbeanstalk_delete_application

#' Deletes the specified version from the specified application
#'
#' Deletes the specified version from the specified application.
#' 
#' You cannot delete an application version that is associated with a
#' running environment.
#'
#' @usage
#' elasticbeanstalk_delete_application_version(ApplicationName,
#'   VersionLabel, DeleteSourceBundle)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to which the version belongs.
#' @param VersionLabel &#91;required&#93; The label of the version to delete.
#' @param DeleteSourceBundle Set to `true` to delete the source bundle from your storage bucket.
#' Otherwise, the application version is deleted only from Elastic
#' Beanstalk and the source bundle remains in Amazon S3.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_version(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   DeleteSourceBundle = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following operation deletes an application version named
#' # 22a0-stage-150819_182129 for an application named my-app:
#' \donttest{svc$delete_application_version(
#'   ApplicationName = "my-app",
#'   DeleteSourceBundle = TRUE,
#'   VersionLabel = "22a0-stage-150819_182129"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_application_version
elasticbeanstalk_delete_application_version <- function(ApplicationName, VersionLabel, DeleteSourceBundle = NULL) {
  op <- new_operation(
    name = "DeleteApplicationVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_application_version_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, DeleteSourceBundle = DeleteSourceBundle)
  output <- .elasticbeanstalk$delete_application_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_application_version <- elasticbeanstalk_delete_application_version

#' Deletes the specified configuration template
#'
#' Deletes the specified configuration template.
#' 
#' When you launch an environment using a configuration template, the
#' environment gets a copy of the template. You can delete or modify the
#' environment\'s copy of the template without affecting the running
#' environment.
#'
#' @usage
#' elasticbeanstalk_delete_configuration_template(ApplicationName,
#'   TemplateName)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to delete the configuration template from.
#' @param TemplateName &#91;required&#93; The name of the configuration template to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_template(
#'   ApplicationName = "string",
#'   TemplateName = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation deletes a configuration template named
#' # my-template for an application named my-app:
#' \donttest{svc$delete_configuration_template(
#'   ApplicationName = "my-app",
#'   TemplateName = "my-template"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_configuration_template
elasticbeanstalk_delete_configuration_template <- function(ApplicationName, TemplateName) {
  op <- new_operation(
    name = "DeleteConfigurationTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_configuration_template_input(ApplicationName = ApplicationName, TemplateName = TemplateName)
  output <- .elasticbeanstalk$delete_configuration_template_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_configuration_template <- elasticbeanstalk_delete_configuration_template

#' Deletes the draft configuration associated with the running environment
#'
#' Deletes the draft configuration associated with the running environment.
#' 
#' Updating a running environment with any configuration changes creates a
#' draft configuration set. You can get the draft configuration using
#' DescribeConfigurationSettings while the update is in progress or if the
#' update fails. The `DeploymentStatus` for the draft configuration
#' indicates whether the deployment is in process or has failed. The draft
#' configuration remains in existence until it is deleted with this action.
#'
#' @usage
#' elasticbeanstalk_delete_environment_configuration(ApplicationName,
#'   EnvironmentName)
#'
#' @param ApplicationName &#91;required&#93; The name of the application the environment is associated with.
#' @param EnvironmentName &#91;required&#93; The name of the environment to delete the draft configuration from.
#'
#' @section Request syntax:
#' ```
#' svc$delete_environment_configuration(
#'   ApplicationName = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation deletes a draft configuration for an environment
#' # named my-env:
#' \donttest{svc$delete_environment_configuration(
#'   ApplicationName = "my-app",
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_environment_configuration
elasticbeanstalk_delete_environment_configuration <- function(ApplicationName, EnvironmentName) {
  op <- new_operation(
    name = "DeleteEnvironmentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_environment_configuration_input(ApplicationName = ApplicationName, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$delete_environment_configuration_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_environment_configuration <- elasticbeanstalk_delete_environment_configuration

#' Deletes the specified version of a custom platform
#'
#' Deletes the specified version of a custom platform.
#'
#' @usage
#' elasticbeanstalk_delete_platform_version(PlatformArn)
#'
#' @param PlatformArn The ARN of the version of the custom platform.
#'
#' @section Request syntax:
#' ```
#' svc$delete_platform_version(
#'   PlatformArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_platform_version
elasticbeanstalk_delete_platform_version <- function(PlatformArn = NULL) {
  op <- new_operation(
    name = "DeletePlatformVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_platform_version_input(PlatformArn = PlatformArn)
  output <- .elasticbeanstalk$delete_platform_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_platform_version <- elasticbeanstalk_delete_platform_version

#' Returns attributes related to AWS Elastic Beanstalk that are associated
#' with the calling AWS account
#'
#' Returns attributes related to AWS Elastic Beanstalk that are associated
#' with the calling AWS account.
#' 
#' The result currently has one set of attributes---resource quotas.
#'
#' @usage
#' elasticbeanstalk_describe_account_attributes()
#'

#'

#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_account_attributes
elasticbeanstalk_describe_account_attributes <- function() {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_account_attributes_input()
  output <- .elasticbeanstalk$describe_account_attributes_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_account_attributes <- elasticbeanstalk_describe_account_attributes

#' Retrieve a list of application versions
#'
#' Retrieve a list of application versions.
#'
#' @usage
#' elasticbeanstalk_describe_application_versions(ApplicationName,
#'   VersionLabels, MaxRecords, NextToken)
#'
#' @param ApplicationName Specify an application name to show only application versions for that
#' application.
#' @param VersionLabels Specify a version label to show a specific application version.
#' @param MaxRecords For a paginated request. Specify a maximum number of application
#' versions to include in each response.
#' 
#' If no `MaxRecords` is specified, all available application versions are
#' retrieved in a single response.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @section Request syntax:
#' ```
#' svc$describe_application_versions(
#'   ApplicationName = "string",
#'   VersionLabels = list(
#'     "string"
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves information about an application
#' # version labeled v2:
#' \donttest{svc$describe_application_versions(
#'   ApplicationName = "my-app",
#'   VersionLabels = list(
#'     "v2"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_application_versions
elasticbeanstalk_describe_application_versions <- function(ApplicationName = NULL, VersionLabels = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeApplicationVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_application_versions_input(ApplicationName = ApplicationName, VersionLabels = VersionLabels, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_application_versions_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_application_versions <- elasticbeanstalk_describe_application_versions

#' Returns the descriptions of existing applications
#'
#' Returns the descriptions of existing applications.
#'
#' @usage
#' elasticbeanstalk_describe_applications(ApplicationNames)
#'
#' @param ApplicationNames If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to only include those with the specified names.
#'
#' @section Request syntax:
#' ```
#' svc$describe_applications(
#'   ApplicationNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves information about applications in the
#' # current region:
#' \donttest{svc$describe_applications()}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_applications
elasticbeanstalk_describe_applications <- function(ApplicationNames = NULL) {
  op <- new_operation(
    name = "DescribeApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_applications_input(ApplicationNames = ApplicationNames)
  output <- .elasticbeanstalk$describe_applications_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_applications <- elasticbeanstalk_describe_applications

#' Describes the configuration options that are used in a particular
#' configuration template or environment, or that a specified solution
#' stack defines
#'
#' Describes the configuration options that are used in a particular
#' configuration template or environment, or that a specified solution
#' stack defines. The description includes the values the options, their
#' default values, and an indication of the required action on a running
#' environment if an option value is changed.
#'
#' @usage
#' elasticbeanstalk_describe_configuration_options(ApplicationName,
#'   TemplateName, EnvironmentName, SolutionStackName, PlatformArn, Options)
#'
#' @param ApplicationName The name of the application associated with the configuration template
#' or environment. Only needed if you want to describe the configuration
#' options associated with either the configuration template or
#' environment.
#' @param TemplateName The name of the configuration template whose configuration options you
#' want to describe.
#' @param EnvironmentName The name of the environment whose configuration options you want to
#' describe.
#' @param SolutionStackName The name of the solution stack whose configuration options you want to
#' describe.
#' @param PlatformArn The ARN of the custom platform.
#' @param Options If specified, restricts the descriptions to only the specified options.
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_options(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   EnvironmentName = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   Options = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves descriptions of all available
#' # configuration options for an environment named my-env:
#' \donttest{svc$describe_configuration_options(
#'   ApplicationName = "my-app",
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_configuration_options
elasticbeanstalk_describe_configuration_options <- function(ApplicationName = NULL, TemplateName = NULL, EnvironmentName = NULL, SolutionStackName = NULL, PlatformArn = NULL, Options = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_configuration_options_input(ApplicationName = ApplicationName, TemplateName = TemplateName, EnvironmentName = EnvironmentName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, Options = Options)
  output <- .elasticbeanstalk$describe_configuration_options_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_configuration_options <- elasticbeanstalk_describe_configuration_options

#' Returns a description of the settings for the specified configuration
#' set, that is, either a configuration template or the configuration set
#' associated with a running environment
#'
#' Returns a description of the settings for the specified configuration
#' set, that is, either a configuration template or the configuration set
#' associated with a running environment.
#' 
#' When describing the settings for the configuration set associated with a
#' running environment, it is possible to receive two sets of setting
#' descriptions. One is the deployed configuration set, and the other is a
#' draft configuration of an environment that is either in the process of
#' deployment or that failed to deploy.
#' 
#' Related Topics
#' 
#' -   DeleteEnvironmentConfiguration
#'
#' @usage
#' elasticbeanstalk_describe_configuration_settings(ApplicationName,
#'   TemplateName, EnvironmentName)
#'
#' @param ApplicationName &#91;required&#93; The application for the environment or configuration template.
#' @param TemplateName The name of the configuration template to describe.
#' 
#' Conditional: You must specify either this parameter or an
#' EnvironmentName, but not both. If you specify both, AWS Elastic
#' Beanstalk returns an `InvalidParameterCombination` error. If you do not
#' specify either, AWS Elastic Beanstalk returns a
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to describe.
#' 
#' Condition: You must specify either this or a TemplateName, but not both.
#' If you specify both, AWS Elastic Beanstalk returns an
#' `InvalidParameterCombination` error. If you do not specify either, AWS
#' Elastic Beanstalk returns `MissingRequiredParameter` error.
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_settings(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves configuration settings for an
#' # environment named my-env:
#' \donttest{svc$describe_configuration_settings(
#'   ApplicationName = "my-app",
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_configuration_settings
elasticbeanstalk_describe_configuration_settings <- function(ApplicationName, TemplateName = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_configuration_settings_input(ApplicationName = ApplicationName, TemplateName = TemplateName, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$describe_configuration_settings_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_configuration_settings <- elasticbeanstalk_describe_configuration_settings

#' Returns information about the overall health of the specified
#' environment
#'
#' Returns information about the overall health of the specified
#' environment. The **DescribeEnvironmentHealth** operation is only
#' available with AWS Elastic Beanstalk Enhanced Health.
#'
#' @usage
#' elasticbeanstalk_describe_environment_health(EnvironmentName,
#'   EnvironmentId, AttributeNames)
#'
#' @param EnvironmentName Specify the environment by name.
#' 
#' You must specify either this or an EnvironmentName, or both.
#' @param EnvironmentId Specify the environment by ID.
#' 
#' You must specify either this or an EnvironmentName, or both.
#' @param AttributeNames Specify the response elements to return. To retrieve all attributes, set
#' to `All`. If no attribute names are specified, returns the name of the
#' environment.
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_health(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   AttributeNames = list(
#'     "Status"|"Color"|"Causes"|"ApplicationMetrics"|"InstancesHealth"|"All"|"HealthStatus"|"RefreshedAt"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves overall health information for an
#' # environment named my-env:
#' \donttest{svc$describe_environment_health(
#'   AttributeNames = list(
#'     "All"
#'   ),
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_health
elasticbeanstalk_describe_environment_health <- function(EnvironmentName = NULL, EnvironmentId = NULL, AttributeNames = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentHealth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_health_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, AttributeNames = AttributeNames)
  output <- .elasticbeanstalk$describe_environment_health_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_health <- elasticbeanstalk_describe_environment_health

#' Lists an environment's completed and failed managed actions
#'
#' Lists an environment\'s completed and failed managed actions.
#'
#' @usage
#' elasticbeanstalk_describe_environment_managed_action_history(
#'   EnvironmentId, EnvironmentName, NextToken, MaxItems)
#'
#' @param EnvironmentId The environment ID of the target environment.
#' @param EnvironmentName The name of the target environment.
#' @param NextToken The pagination token returned by a previous request.
#' @param MaxItems The maximum number of items to return for a single request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_managed_action_history(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   NextToken = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_managed_action_history
elasticbeanstalk_describe_environment_managed_action_history <- function(EnvironmentId = NULL, EnvironmentName = NULL, NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentManagedActionHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_managed_action_history_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, NextToken = NextToken, MaxItems = MaxItems)
  output <- .elasticbeanstalk$describe_environment_managed_action_history_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_managed_action_history <- elasticbeanstalk_describe_environment_managed_action_history

#' Lists an environment's upcoming and in-progress managed actions
#'
#' Lists an environment\'s upcoming and in-progress managed actions.
#'
#' @usage
#' elasticbeanstalk_describe_environment_managed_actions(EnvironmentName,
#'   EnvironmentId, Status)
#'
#' @param EnvironmentName The name of the target environment.
#' @param EnvironmentId The environment ID of the target environment.
#' @param Status To show only actions with a particular status, specify a status.
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_managed_actions(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   Status = "Scheduled"|"Pending"|"Running"|"Unknown"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_managed_actions
elasticbeanstalk_describe_environment_managed_actions <- function(EnvironmentName = NULL, EnvironmentId = NULL, Status = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentManagedActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_managed_actions_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, Status = Status)
  output <- .elasticbeanstalk$describe_environment_managed_actions_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_managed_actions <- elasticbeanstalk_describe_environment_managed_actions

#' Returns AWS resources for this environment
#'
#' Returns AWS resources for this environment.
#'
#' @usage
#' elasticbeanstalk_describe_environment_resources(EnvironmentId,
#'   EnvironmentName)
#'
#' @param EnvironmentId The ID of the environment to retrieve AWS resource usage data.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to retrieve AWS resource usage data.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_resources(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves information about resources in an
#' # environment named my-env:
#' \donttest{svc$describe_environment_resources(
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_resources
elasticbeanstalk_describe_environment_resources <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_resources_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$describe_environment_resources_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_resources <- elasticbeanstalk_describe_environment_resources

#' Returns descriptions for existing environments
#'
#' Returns descriptions for existing environments.
#'
#' @usage
#' elasticbeanstalk_describe_environments(ApplicationName, VersionLabel,
#'   EnvironmentIds, EnvironmentNames, IncludeDeleted, IncludedDeletedBackTo,
#'   MaxRecords, NextToken)
#'
#' @param ApplicationName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that are associated with this application.
#' @param VersionLabel If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that are associated with this application version.
#' @param EnvironmentIds If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that have the specified IDs.
#' @param EnvironmentNames If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that have the specified names.
#' @param IncludeDeleted Indicates whether to include deleted environments:
#' 
#' `true`: Environments that have been deleted after
#' `IncludedDeletedBackTo` are displayed.
#' 
#' `false`: Do not include deleted environments.
#' @param IncludedDeletedBackTo If specified when `IncludeDeleted` is set to `true`, then environments
#' deleted after this date are displayed.
#' @param MaxRecords For a paginated request. Specify a maximum number of environments to
#' include in each response.
#' 
#' If no `MaxRecords` is specified, all available environments are
#' retrieved in a single response.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @section Request syntax:
#' ```
#' svc$describe_environments(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   EnvironmentIds = list(
#'     "string"
#'   ),
#'   EnvironmentNames = list(
#'     "string"
#'   ),
#'   IncludeDeleted = TRUE|FALSE,
#'   IncludedDeletedBackTo = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves information about an environment named
#' # my-env:
#' \donttest{svc$describe_environments(
#'   EnvironmentNames = list(
#'     "my-env"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environments
elasticbeanstalk_describe_environments <- function(ApplicationName = NULL, VersionLabel = NULL, EnvironmentIds = NULL, EnvironmentNames = NULL, IncludeDeleted = NULL, IncludedDeletedBackTo = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEnvironments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environments_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, EnvironmentIds = EnvironmentIds, EnvironmentNames = EnvironmentNames, IncludeDeleted = IncludeDeleted, IncludedDeletedBackTo = IncludedDeletedBackTo, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_environments_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environments <- elasticbeanstalk_describe_environments

#' Returns list of event descriptions matching criteria up to the last 6
#' weeks
#'
#' Returns list of event descriptions matching criteria up to the last 6
#' weeks.
#' 
#' This action returns the most recent 1,000 events from the specified
#' `NextToken`.
#'
#' @usage
#' elasticbeanstalk_describe_events(ApplicationName, VersionLabel,
#'   TemplateName, EnvironmentId, EnvironmentName, PlatformArn, RequestId,
#'   Severity, StartTime, EndTime, MaxRecords, NextToken)
#'
#' @param ApplicationName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those associated with this application.
#' @param VersionLabel If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those associated with this application version.
#' @param TemplateName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those that are associated with this environment configuration.
#' @param EnvironmentId If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those associated with this environment.
#' @param EnvironmentName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those associated with this environment.
#' @param PlatformArn The ARN of the version of the custom platform.
#' @param RequestId If specified, AWS Elastic Beanstalk restricts the described events to
#' include only those associated with this request ID.
#' @param Severity If specified, limits the events returned from this call to include only
#' those with the specified severity or higher.
#' @param StartTime If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those that occur on or after this time.
#' @param EndTime If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those that occur up to, but not including, the `EndTime`.
#' @param MaxRecords Specifies the maximum number of events that can be returned, beginning
#' with the most recent event.
#' @param NextToken Pagination token. If specified, the events return the next batch of
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   TemplateName = "string",
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   PlatformArn = "string",
#'   RequestId = "string",
#'   Severity = "TRACE"|"DEBUG"|"INFO"|"WARN"|"ERROR"|"FATAL",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves events for an environment named
#' # my-env:
#' \donttest{svc$describe_events(
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_events
elasticbeanstalk_describe_events <- function(ApplicationName = NULL, VersionLabel = NULL, TemplateName = NULL, EnvironmentId = NULL, EnvironmentName = NULL, PlatformArn = NULL, RequestId = NULL, Severity = NULL, StartTime = NULL, EndTime = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_events_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, TemplateName = TemplateName, EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, PlatformArn = PlatformArn, RequestId = RequestId, Severity = Severity, StartTime = StartTime, EndTime = EndTime, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_events_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_events <- elasticbeanstalk_describe_events

#' Retrieves detailed information about the health of instances in your AWS
#' Elastic Beanstalk
#'
#' Retrieves detailed information about the health of instances in your AWS
#' Elastic Beanstalk. This operation requires [enhanced health
#' reporting](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html).
#'
#' @usage
#' elasticbeanstalk_describe_instances_health(EnvironmentName,
#'   EnvironmentId, AttributeNames, NextToken)
#'
#' @param EnvironmentName Specify the AWS Elastic Beanstalk environment by name.
#' @param EnvironmentId Specify the AWS Elastic Beanstalk environment by ID.
#' @param AttributeNames Specifies the response elements you wish to receive. To retrieve all
#' attributes, set to `All`. If no attribute names are specified, returns a
#' list of instances.
#' @param NextToken Specify the pagination token returned by a previous call.
#'
#' @section Request syntax:
#' ```
#' svc$describe_instances_health(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   AttributeNames = list(
#'     "HealthStatus"|"Color"|"Causes"|"ApplicationMetrics"|"RefreshedAt"|"LaunchedAt"|"System"|"Deployment"|"AvailabilityZone"|"InstanceType"|"All"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves health information for instances in an
#' # environment named my-env:
#' \donttest{svc$describe_instances_health(
#'   AttributeNames = list(
#'     "All"
#'   ),
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_instances_health
elasticbeanstalk_describe_instances_health <- function(EnvironmentName = NULL, EnvironmentId = NULL, AttributeNames = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstancesHealth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_instances_health_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, AttributeNames = AttributeNames, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_instances_health_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_instances_health <- elasticbeanstalk_describe_instances_health

#' Describes the version of the platform
#'
#' Describes the version of the platform.
#'
#' @usage
#' elasticbeanstalk_describe_platform_version(PlatformArn)
#'
#' @param PlatformArn The ARN of the version of the platform.
#'
#' @section Request syntax:
#' ```
#' svc$describe_platform_version(
#'   PlatformArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_platform_version
elasticbeanstalk_describe_platform_version <- function(PlatformArn = NULL) {
  op <- new_operation(
    name = "DescribePlatformVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_platform_version_input(PlatformArn = PlatformArn)
  output <- .elasticbeanstalk$describe_platform_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_platform_version <- elasticbeanstalk_describe_platform_version

#' Returns a list of the available solution stack names, with the public
#' version first and then in reverse chronological order
#'
#' Returns a list of the available solution stack names, with the public
#' version first and then in reverse chronological order.
#'
#' @usage
#' elasticbeanstalk_list_available_solution_stacks()
#'

#'

#'
#' @examples
#' # The following operation lists solution stacks for all currently
#' # available platform configurations and any that you have used in the
#' # past:
#' \donttest{svc$list_available_solution_stacks()}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_available_solution_stacks
elasticbeanstalk_list_available_solution_stacks <- function() {
  op <- new_operation(
    name = "ListAvailableSolutionStacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$list_available_solution_stacks_input()
  output <- .elasticbeanstalk$list_available_solution_stacks_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_available_solution_stacks <- elasticbeanstalk_list_available_solution_stacks

#' Lists the available platforms
#'
#' Lists the available platforms.
#'
#' @usage
#' elasticbeanstalk_list_platform_versions(Filters, MaxRecords, NextToken)
#'
#' @param Filters List only the platforms where the platform member value relates to one
#' of the supplied values.
#' @param MaxRecords The maximum number of platform values returned in one call.
#' @param NextToken The starting index into the remaining list of platforms. Use the
#' `NextToken` value from a previous `ListPlatformVersion` call.
#'
#' @section Request syntax:
#' ```
#' svc$list_platform_versions(
#'   Filters = list(
#'     list(
#'       Type = "string",
#'       Operator = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_platform_versions
elasticbeanstalk_list_platform_versions <- function(Filters = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPlatformVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$list_platform_versions_input(Filters = Filters, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$list_platform_versions_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_platform_versions <- elasticbeanstalk_list_platform_versions

#' Returns the tags applied to an AWS Elastic Beanstalk resource
#'
#' Returns the tags applied to an AWS Elastic Beanstalk resource. The
#' response contains a list of tag key-value pairs.
#' 
#' Currently, Elastic Beanstalk only supports tagging of Elastic Beanstalk
#' environments. For details about environment tagging, see [Tagging
#' Resources in Your Elastic Beanstalk
#' Environment](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/using-features.tagging.html).
#'
#' @usage
#' elasticbeanstalk_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resouce for which a tag list is
#' requested.
#' 
#' Must be the ARN of an Elastic Beanstalk environment.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_tags_for_resource
elasticbeanstalk_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .elasticbeanstalk$list_tags_for_resource_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_tags_for_resource <- elasticbeanstalk_list_tags_for_resource

#' Deletes and recreates all of the AWS resources (for example: the Auto
#' Scaling group, load balancer, etc
#'
#' Deletes and recreates all of the AWS resources (for example: the Auto
#' Scaling group, load balancer, etc.) for a specified environment and
#' forces a restart.
#'
#' @usage
#' elasticbeanstalk_rebuild_environment(EnvironmentId, EnvironmentName)
#'
#' @param EnvironmentId The ID of the environment to rebuild.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to rebuild.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#'
#' @section Request syntax:
#' ```
#' svc$rebuild_environment(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation terminates and recreates the resources in an
#' # environment named my-env:
#' \donttest{svc$rebuild_environment(
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_rebuild_environment
elasticbeanstalk_rebuild_environment <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "RebuildEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$rebuild_environment_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$rebuild_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$rebuild_environment <- elasticbeanstalk_rebuild_environment

#' Initiates a request to compile the specified type of information of the
#' deployed environment
#'
#' Initiates a request to compile the specified type of information of the
#' deployed environment.
#' 
#' Setting the `InfoType` to `tail` compiles the last lines from the
#' application server log files of every Amazon EC2 instance in your
#' environment.
#' 
#' Setting the `InfoType` to `bundle` compresses the application server log
#' files for every Amazon EC2 instance into a `.zip` file. Legacy and .NET
#' containers do not support bundle logs.
#' 
#' Use RetrieveEnvironmentInfo to obtain the set of logs.
#' 
#' Related Topics
#' 
#' -   RetrieveEnvironmentInfo
#'
#' @usage
#' elasticbeanstalk_request_environment_info(EnvironmentId,
#'   EnvironmentName, InfoType)
#'
#' @param EnvironmentId The ID of the environment of the requested data.
#' 
#' If no such environment is found, `RequestEnvironmentInfo` returns an
#' `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment of the requested data.
#' 
#' If no such environment is found, `RequestEnvironmentInfo` returns an
#' `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param InfoType &#91;required&#93; The type of information to request.
#'
#' @section Request syntax:
#' ```
#' svc$request_environment_info(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   InfoType = "tail"|"bundle"
#' )
#' ```
#'
#' @examples
#' # The following operation requests logs from an environment named my-env:
#' \donttest{svc$request_environment_info(
#'   EnvironmentName = "my-env",
#'   InfoType = "tail"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_request_environment_info
elasticbeanstalk_request_environment_info <- function(EnvironmentId = NULL, EnvironmentName = NULL, InfoType) {
  op <- new_operation(
    name = "RequestEnvironmentInfo",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$request_environment_info_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, InfoType = InfoType)
  output <- .elasticbeanstalk$request_environment_info_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$request_environment_info <- elasticbeanstalk_request_environment_info

#' Causes the environment to restart the application container server
#' running on each Amazon EC2 instance
#'
#' Causes the environment to restart the application container server
#' running on each Amazon EC2 instance.
#'
#' @usage
#' elasticbeanstalk_restart_app_server(EnvironmentId, EnvironmentName)
#'
#' @param EnvironmentId The ID of the environment to restart the server for.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to restart the server for.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#'
#' @section Request syntax:
#' ```
#' svc$restart_app_server(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation restarts application servers on all instances in
#' # an environment named my-env:
#' \donttest{svc$restart_app_server(
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_restart_app_server
elasticbeanstalk_restart_app_server <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "RestartAppServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$restart_app_server_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$restart_app_server_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$restart_app_server <- elasticbeanstalk_restart_app_server

#' Retrieves the compiled information from a RequestEnvironmentInfo request
#'
#' Retrieves the compiled information from a RequestEnvironmentInfo
#' request.
#' 
#' Related Topics
#' 
#' -   RequestEnvironmentInfo
#'
#' @usage
#' elasticbeanstalk_retrieve_environment_info(EnvironmentId,
#'   EnvironmentName, InfoType)
#'
#' @param EnvironmentId The ID of the data\'s environment.
#' 
#' If no such environment is found, returns an `InvalidParameterValue`
#' error.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the data\'s environment.
#' 
#' If no such environment is found, returns an `InvalidParameterValue`
#' error.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param InfoType &#91;required&#93; The type of information to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$retrieve_environment_info(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   InfoType = "tail"|"bundle"
#' )
#' ```
#'
#' @examples
#' # The following operation retrieves a link to logs from an environment
#' # named my-env:
#' \donttest{svc$retrieve_environment_info(
#'   EnvironmentName = "my-env",
#'   InfoType = "tail"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_retrieve_environment_info
elasticbeanstalk_retrieve_environment_info <- function(EnvironmentId = NULL, EnvironmentName = NULL, InfoType) {
  op <- new_operation(
    name = "RetrieveEnvironmentInfo",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$retrieve_environment_info_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, InfoType = InfoType)
  output <- .elasticbeanstalk$retrieve_environment_info_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$retrieve_environment_info <- elasticbeanstalk_retrieve_environment_info

#' Swaps the CNAMEs of two environments
#'
#' Swaps the CNAMEs of two environments.
#'
#' @usage
#' elasticbeanstalk_swap_environment_cnam_es(SourceEnvironmentId,
#'   SourceEnvironmentName, DestinationEnvironmentId,
#'   DestinationEnvironmentName)
#'
#' @param SourceEnvironmentId The ID of the source environment.
#' 
#' Condition: You must specify at least the `SourceEnvironmentID` or the
#' `SourceEnvironmentName`. You may also specify both. If you specify the
#' `SourceEnvironmentId`, you must specify the `DestinationEnvironmentId`.
#' @param SourceEnvironmentName The name of the source environment.
#' 
#' Condition: You must specify at least the `SourceEnvironmentID` or the
#' `SourceEnvironmentName`. You may also specify both. If you specify the
#' `SourceEnvironmentName`, you must specify the
#' `DestinationEnvironmentName`.
#' @param DestinationEnvironmentId The ID of the destination environment.
#' 
#' Condition: You must specify at least the `DestinationEnvironmentID` or
#' the `DestinationEnvironmentName`. You may also specify both. You must
#' specify the `SourceEnvironmentId` with the `DestinationEnvironmentId`.
#' @param DestinationEnvironmentName The name of the destination environment.
#' 
#' Condition: You must specify at least the `DestinationEnvironmentID` or
#' the `DestinationEnvironmentName`. You may also specify both. You must
#' specify the `SourceEnvironmentName` with the
#' `DestinationEnvironmentName`.
#'
#' @section Request syntax:
#' ```
#' svc$swap_environment_cnam_es(
#'   SourceEnvironmentId = "string",
#'   SourceEnvironmentName = "string",
#'   DestinationEnvironmentId = "string",
#'   DestinationEnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation swaps the assigned subdomains of two
#' # environments:
#' \donttest{svc$swap_environment_cnam_es(
#'   DestinationEnvironmentName = "my-env-green",
#'   SourceEnvironmentName = "my-env-blue"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_swap_environment_cnam_es
elasticbeanstalk_swap_environment_cnam_es <- function(SourceEnvironmentId = NULL, SourceEnvironmentName = NULL, DestinationEnvironmentId = NULL, DestinationEnvironmentName = NULL) {
  op <- new_operation(
    name = "SwapEnvironmentCNAMEs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$swap_environment_cnam_es_input(SourceEnvironmentId = SourceEnvironmentId, SourceEnvironmentName = SourceEnvironmentName, DestinationEnvironmentId = DestinationEnvironmentId, DestinationEnvironmentName = DestinationEnvironmentName)
  output <- .elasticbeanstalk$swap_environment_cnam_es_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$swap_environment_cnam_es <- elasticbeanstalk_swap_environment_cnam_es

#' Terminates the specified environment
#'
#' Terminates the specified environment.
#'
#' @usage
#' elasticbeanstalk_terminate_environment(EnvironmentId, EnvironmentName,
#'   TerminateResources, ForceTerminate)
#'
#' @param EnvironmentId The ID of the environment to terminate.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to terminate.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param TerminateResources Indicates whether the associated AWS resources should shut down when the
#' environment is terminated:
#' 
#' -   `true`: The specified environment as well as the associated AWS
#'     resources, such as Auto Scaling group and LoadBalancer, are
#'     terminated.
#' 
#' -   `false`: AWS Elastic Beanstalk resource management is removed from
#'     the environment, but the AWS resources continue to operate.
#' 
#' For more information, see the [AWS Elastic Beanstalk User
#' Guide.](https://docs.aws.amazon.com/elasticbeanstalk/latest/ug/)
#' 
#' Default: `true`
#' 
#' Valid Values: `true` \\| `false`
#' @param ForceTerminate Terminates the target environment even if another environment in the
#' same group is dependent on it.
#'
#' @section Request syntax:
#' ```
#' svc$terminate_environment(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   TerminateResources = TRUE|FALSE,
#'   ForceTerminate = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following operation terminates an Elastic Beanstalk environment
#' # named my-env:
#' \donttest{svc$terminate_environment(
#'   EnvironmentName = "my-env"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_terminate_environment
elasticbeanstalk_terminate_environment <- function(EnvironmentId = NULL, EnvironmentName = NULL, TerminateResources = NULL, ForceTerminate = NULL) {
  op <- new_operation(
    name = "TerminateEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$terminate_environment_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, TerminateResources = TerminateResources, ForceTerminate = ForceTerminate)
  output <- .elasticbeanstalk$terminate_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$terminate_environment <- elasticbeanstalk_terminate_environment

#' Updates the specified application to have the specified properties
#'
#' Updates the specified application to have the specified properties.
#' 
#' If a property (for example, `description`) is not provided, the value
#' remains unchanged. To clear these properties, specify an empty string.
#'
#' @usage
#' elasticbeanstalk_update_application(ApplicationName, Description)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to update. If no such application is found,
#' `UpdateApplication` returns an `InvalidParameterValue` error.
#' @param Description A new description for the application.
#' 
#' Default: If not specified, AWS Elastic Beanstalk does not update the
#' description.
#'
#' @section Request syntax:
#' ```
#' svc$update_application(
#'   ApplicationName = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation updates the description of an application named
#' # my-app:
#' \donttest{svc$update_application(
#'   ApplicationName = "my-app",
#'   Description = "my Elastic Beanstalk application"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_application
elasticbeanstalk_update_application <- function(ApplicationName, Description = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_application_input(ApplicationName = ApplicationName, Description = Description)
  output <- .elasticbeanstalk$update_application_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_application <- elasticbeanstalk_update_application

#' Modifies lifecycle settings for an application
#'
#' Modifies lifecycle settings for an application.
#'
#' @usage
#' elasticbeanstalk_update_application_resource_lifecycle(ApplicationName,
#'   ResourceLifecycleConfig)
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param ResourceLifecycleConfig &#91;required&#93; The lifecycle configuration.
#'
#' @section Request syntax:
#' ```
#' svc$update_application_resource_lifecycle(
#'   ApplicationName = "string",
#'   ResourceLifecycleConfig = list(
#'     ServiceRole = "string",
#'     VersionLifecycleConfig = list(
#'       MaxCountRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxCount = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       ),
#'       MaxAgeRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxAgeInDays = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_application_resource_lifecycle
elasticbeanstalk_update_application_resource_lifecycle <- function(ApplicationName, ResourceLifecycleConfig) {
  op <- new_operation(
    name = "UpdateApplicationResourceLifecycle",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_application_resource_lifecycle_input(ApplicationName = ApplicationName, ResourceLifecycleConfig = ResourceLifecycleConfig)
  output <- .elasticbeanstalk$update_application_resource_lifecycle_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_application_resource_lifecycle <- elasticbeanstalk_update_application_resource_lifecycle

#' Updates the specified application version to have the specified
#' properties
#'
#' Updates the specified application version to have the specified
#' properties.
#' 
#' If a property (for example, `description`) is not provided, the value
#' remains unchanged. To clear properties, specify an empty string.
#'
#' @usage
#' elasticbeanstalk_update_application_version(ApplicationName,
#'   VersionLabel, Description)
#'
#' @param ApplicationName &#91;required&#93; The name of the application associated with this version.
#' 
#' If no application is found with this name, `UpdateApplication` returns
#' an `InvalidParameterValue` error.
#' @param VersionLabel &#91;required&#93; The name of the version to update.
#' 
#' If no application version is found with this label, `UpdateApplication`
#' returns an `InvalidParameterValue` error.
#' @param Description A new description for this version.
#'
#' @section Request syntax:
#' ```
#' svc$update_application_version(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @examples
#' # The following operation updates the description of an application
#' # version named 22a0-stage-150819_185942:
#' \donttest{svc$update_application_version(
#'   ApplicationName = "my-app",
#'   Description = "new description",
#'   VersionLabel = "22a0-stage-150819_185942"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_application_version
elasticbeanstalk_update_application_version <- function(ApplicationName, VersionLabel, Description = NULL) {
  op <- new_operation(
    name = "UpdateApplicationVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_application_version_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, Description = Description)
  output <- .elasticbeanstalk$update_application_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_application_version <- elasticbeanstalk_update_application_version

#' Updates the specified configuration template to have the specified
#' properties or configuration option values
#'
#' Updates the specified configuration template to have the specified
#' properties or configuration option values.
#' 
#' If a property (for example, `ApplicationName`) is not provided, its
#' value remains unchanged. To clear such properties, specify an empty
#' string.
#' 
#' Related Topics
#' 
#' -   DescribeConfigurationOptions
#'
#' @usage
#' elasticbeanstalk_update_configuration_template(ApplicationName,
#'   TemplateName, Description, OptionSettings, OptionsToRemove)
#'
#' @param ApplicationName &#91;required&#93; The name of the application associated with the configuration template
#' to update.
#' 
#' If no application is found with this name, `UpdateConfigurationTemplate`
#' returns an `InvalidParameterValue` error.
#' @param TemplateName &#91;required&#93; The name of the configuration template to update.
#' 
#' If no configuration template is found with this name,
#' `UpdateConfigurationTemplate` returns an `InvalidParameterValue` error.
#' @param Description A new description for the configuration.
#' @param OptionSettings A list of configuration option settings to update with the new specified
#' option value.
#' @param OptionsToRemove A list of configuration options to remove from the configuration set.
#' 
#' Constraint: You can remove only `UserDefined` configuration options.
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration_template(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   Description = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   OptionsToRemove = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation removes the configured CloudWatch custom health
#' # metrics configuration ConfigDocument from a saved configuration template
#' # named my-template:
#' \donttest{svc$update_configuration_template(
#'   ApplicationName = "my-app",
#'   OptionsToRemove = list(
#'     list(
#'       Namespace = "aws:elasticbeanstalk:healthreporting:system",
#'       OptionName = "ConfigDocument"
#'     )
#'   ),
#'   TemplateName = "my-template"
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_configuration_template
elasticbeanstalk_update_configuration_template <- function(ApplicationName, TemplateName, Description = NULL, OptionSettings = NULL, OptionsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateConfigurationTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_configuration_template_input(ApplicationName = ApplicationName, TemplateName = TemplateName, Description = Description, OptionSettings = OptionSettings, OptionsToRemove = OptionsToRemove)
  output <- .elasticbeanstalk$update_configuration_template_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_configuration_template <- elasticbeanstalk_update_configuration_template

#' Updates the environment description, deploys a new application version,
#' updates the configuration settings to an entirely new configuration
#' template, or updates select configuration option values in the running
#' environment
#'
#' Updates the environment description, deploys a new application version,
#' updates the configuration settings to an entirely new configuration
#' template, or updates select configuration option values in the running
#' environment.
#' 
#' Attempting to update both the release and configuration is not allowed
#' and AWS Elastic Beanstalk returns an `InvalidParameterCombination`
#' error.
#' 
#' When updating the configuration settings to a new template or individual
#' settings, a draft configuration is created and
#' DescribeConfigurationSettings for this environment returns two setting
#' descriptions with different `DeploymentStatus` values.
#'
#' @usage
#' elasticbeanstalk_update_environment(ApplicationName, EnvironmentId,
#'   EnvironmentName, GroupName, Description, Tier, VersionLabel,
#'   TemplateName, SolutionStackName, PlatformArn, OptionSettings,
#'   OptionsToRemove)
#'
#' @param ApplicationName The name of the application with which the environment is associated.
#' @param EnvironmentId The ID of the environment to update.
#' 
#' If no environment with this ID exists, AWS Elastic Beanstalk returns an
#' `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to update. If no environment with this name
#' exists, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param GroupName The name of the group to which the target environment belongs. Specify a
#' group name only if the environment\'s name is specified in an
#' environment manifest and not with the environment name or environment ID
#' parameters. See [Environment Manifest
#' (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
#' for details.
#' @param Description If this parameter is specified, AWS Elastic Beanstalk updates the
#' description of this environment.
#' @param Tier This specifies the tier to use to update the environment.
#' 
#' Condition: At this time, if you change the tier version, name, or type,
#' AWS Elastic Beanstalk returns `InvalidParameterValue` error.
#' @param VersionLabel If this parameter is specified, AWS Elastic Beanstalk deploys the named
#' application version to the environment. If no such application version
#' is found, returns an `InvalidParameterValue` error.
#' @param TemplateName If this parameter is specified, AWS Elastic Beanstalk deploys this
#' configuration template to the environment. If no such configuration
#' template is found, AWS Elastic Beanstalk returns an
#' `InvalidParameterValue` error.
#' @param SolutionStackName This specifies the platform version that the environment will run after
#' the environment is updated.
#' @param PlatformArn The ARN of the platform, if used.
#' @param OptionSettings If specified, AWS Elastic Beanstalk updates the configuration set
#' associated with the running environment and sets the specified
#' configuration options to the requested value.
#' @param OptionsToRemove A list of custom user-defined configuration options to remove from the
#' configuration set for this environment.
#'
#' @section Request syntax:
#' ```
#' svc$update_environment(
#'   ApplicationName = "string",
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   GroupName = "string",
#'   Description = "string",
#'   Tier = list(
#'     Name = "string",
#'     Type = "string",
#'     Version = "string"
#'   ),
#'   VersionLabel = "string",
#'   TemplateName = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   OptionsToRemove = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation updates an environment named "my-env" to version
#' # "v2" of the application to which it belongs:
#' \donttest{svc$update_environment(
#'   EnvironmentName = "my-env",
#'   VersionLabel = "v2"
#' )}
#' 
#' # The following operation configures several options in the
#' # aws:elb:loadbalancer namespace:
#' \donttest{svc$update_environment(
#'   EnvironmentName = "my-env",
#'   OptionSettings = list(
#'     list(
#'       Namespace = "aws:elb:healthcheck",
#'       OptionName = "Interval",
#'       Value = "15"
#'     ),
#'     list(
#'       Namespace = "aws:elb:healthcheck",
#'       OptionName = "Timeout",
#'       Value = "8"
#'     ),
#'     list(
#'       Namespace = "aws:elb:healthcheck",
#'       OptionName = "HealthyThreshold",
#'       Value = "2"
#'     ),
#'     list(
#'       Namespace = "aws:elb:healthcheck",
#'       OptionName = "UnhealthyThreshold",
#'       Value = "3"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_environment
elasticbeanstalk_update_environment <- function(ApplicationName = NULL, EnvironmentId = NULL, EnvironmentName = NULL, GroupName = NULL, Description = NULL, Tier = NULL, VersionLabel = NULL, TemplateName = NULL, SolutionStackName = NULL, PlatformArn = NULL, OptionSettings = NULL, OptionsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_environment_input(ApplicationName = ApplicationName, EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, GroupName = GroupName, Description = Description, Tier = Tier, VersionLabel = VersionLabel, TemplateName = TemplateName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, OptionSettings = OptionSettings, OptionsToRemove = OptionsToRemove)
  output <- .elasticbeanstalk$update_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_environment <- elasticbeanstalk_update_environment

#' Update the list of tags applied to an AWS Elastic Beanstalk resource
#'
#' Update the list of tags applied to an AWS Elastic Beanstalk resource.
#' Two lists can be passed: `TagsToAdd` for tags to add or update, and
#' `TagsToRemove`.
#' 
#' Currently, Elastic Beanstalk only supports tagging of Elastic Beanstalk
#' environments. For details about environment tagging, see [Tagging
#' Resources in Your Elastic Beanstalk
#' Environment](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/using-features.tagging.html).
#' 
#' If you create a custom IAM user policy to control permission to this
#' operation, specify one of the following two virtual actions (or both)
#' instead of the API operation name:
#' 
#' elasticbeanstalk:AddTags
#' 
#' :   Controls permission to call `UpdateTagsForResource` and pass a list
#'     of tags to add in the `TagsToAdd` parameter.
#' 
#' elasticbeanstalk:RemoveTags
#' 
#' :   Controls permission to call `UpdateTagsForResource` and pass a list
#'     of tag keys to remove in the `TagsToRemove` parameter.
#' 
#' For details about creating a custom user policy, see [Creating a Custom
#' User
#' Policy](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies).
#'
#' @usage
#' elasticbeanstalk_update_tags_for_resource(ResourceArn, TagsToAdd,
#'   TagsToRemove)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resouce to be updated.
#' 
#' Must be the ARN of an Elastic Beanstalk environment.
#' @param TagsToAdd A list of tags to add or update.
#' 
#' If a key of an existing tag is added, the tag\'s value is updated.
#' @param TagsToRemove A list of tag keys to remove.
#' 
#' If a tag key doesn\'t exist, it is silently ignored.
#'
#' @section Request syntax:
#' ```
#' svc$update_tags_for_resource(
#'   ResourceArn = "string",
#'   TagsToAdd = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   TagsToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_tags_for_resource
elasticbeanstalk_update_tags_for_resource <- function(ResourceArn, TagsToAdd = NULL, TagsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_tags_for_resource_input(ResourceArn = ResourceArn, TagsToAdd = TagsToAdd, TagsToRemove = TagsToRemove)
  output <- .elasticbeanstalk$update_tags_for_resource_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_tags_for_resource <- elasticbeanstalk_update_tags_for_resource

#' Takes a set of configuration settings and either a configuration
#' template or environment, and determines whether those values are valid
#'
#' Takes a set of configuration settings and either a configuration
#' template or environment, and determines whether those values are valid.
#' 
#' This action returns a list of messages indicating any errors or warnings
#' associated with the selection of option values.
#'
#' @usage
#' elasticbeanstalk_validate_configuration_settings(ApplicationName,
#'   TemplateName, EnvironmentName, OptionSettings)
#'
#' @param ApplicationName &#91;required&#93; The name of the application that the configuration template or
#' environment belongs to.
#' @param TemplateName The name of the configuration template to validate the settings against.
#' 
#' Condition: You cannot specify both this and an environment name.
#' @param EnvironmentName The name of the environment to validate the settings against.
#' 
#' Condition: You cannot specify both this and a configuration template
#' name.
#' @param OptionSettings &#91;required&#93; A list of the options and desired values to evaluate.
#'
#' @section Request syntax:
#' ```
#' svc$validate_configuration_settings(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   EnvironmentName = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following operation validates a CloudWatch custom metrics config
#' # document:
#' \donttest{svc$validate_configuration_settings(
#'   ApplicationName = "my-app",
#'   EnvironmentName = "my-env",
#'   OptionSettings = list(
#'     list(
#'       Namespace = "aws:elasticbeanstalk:healthreporting:system",
#'       OptionName = "ConfigDocument",
#'       Value = "{\"CloudWatchMetrics\": {\"Environment\": {\"ApplicationLatencyP99.9\": null,..."
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_validate_configuration_settings
elasticbeanstalk_validate_configuration_settings <- function(ApplicationName, TemplateName = NULL, EnvironmentName = NULL, OptionSettings) {
  op <- new_operation(
    name = "ValidateConfigurationSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$validate_configuration_settings_input(ApplicationName = ApplicationName, TemplateName = TemplateName, EnvironmentName = EnvironmentName, OptionSettings = OptionSettings)
  output <- .elasticbeanstalk$validate_configuration_settings_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$validate_configuration_settings <- elasticbeanstalk_validate_configuration_settings
