% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_load_balancer_metric_data}
\alias{lightsail_get_load_balancer_metric_data}
\title{Returns information about health metrics for your Lightsail load
balancer}
\usage{
lightsail_get_load_balancer_metric_data(loadBalancerName, metricName,
  period, startTime, endTime, unit, statistics)
}
\arguments{
\item{loadBalancerName}{[required] The name of the load balancer.}

\item{metricName}{[required] The metric about which you want to return information. Valid values are
listed below, along with the most useful \code{statistics} to include in your
request.
\itemize{
\item \strong{\code{ClientTLSNegotiationErrorCount}} - The number of TLS connections
initiated by the client that did not establish a session with the
load balancer. Possible causes include a mismatch of ciphers or
protocols.

\code{Statistics}: The most useful statistic is \code{Sum}.
\item \strong{\code{HealthyHostCount}} - The number of target instances that are
considered healthy.

\code{Statistics}: The most useful statistic are \code{Average}, \code{Minimum},
and \code{Maximum}.
\item \strong{\code{UnhealthyHostCount}} - The number of target instances that are
considered unhealthy.

\code{Statistics}: The most useful statistic are \code{Average}, \code{Minimum},
and \code{Maximum}.
\item \strong{\code{HTTPCode_LB_4XX_Count}} - The number of HTTP 4XX client error
codes that originate from the load balancer. Client errors are
generated when requests are malformed or incomplete. These requests
have not been received by the target instance. This count does not
include any response codes generated by the target instances.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.
\item \strong{\code{HTTPCode_LB_5XX_Count}} - The number of HTTP 5XX server error
codes that originate from the load balancer. This count does not
include any response codes generated by the target instances.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.
\item \strong{\code{HTTPCode_Instance_2XX_Count}} - The number of HTTP response
codes generated by the target instances. This does not include any
response codes generated by the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.
\item \strong{\code{HTTPCode_Instance_3XX_Count}} - The number of HTTP response
codes generated by the target instances. This does not include any
response codes generated by the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.
\item \strong{\code{HTTPCode_Instance_4XX_Count}} - The number of HTTP response
codes generated by the target instances. This does not include any
response codes generated by the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.
\item \strong{\code{HTTPCode_Instance_5XX_Count}} - The number of HTTP response
codes generated by the target instances. This does not include any
response codes generated by the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.
\item \strong{\code{InstanceResponseTime}} - The time elapsed, in seconds, after the
request leaves the load balancer until a response from the target
instance is received.

\code{Statistics}: The most useful statistic is \code{Average}.
\item \strong{\code{RejectedConnectionCount}} - The number of connections that were
rejected because the load balancer had reached its maximum number of
connections.

\code{Statistics}: The most useful statistic is \code{Sum}.
\item \strong{\code{RequestCount}} - The number of requests processed over IPv4.
This count includes only the requests with a response generated by a
target instance of the load balancer.

\code{Statistics}: The most useful statistic is \code{Sum}. Note that
\code{Minimum}, \code{Maximum}, and \code{Average} all return \code{1}.
}}

\item{period}{[required] The granularity, in seconds, of the returned data points.}

\item{startTime}{[required] The start time of the period.}

\item{endTime}{[required] The end time of the period.}

\item{unit}{[required] The unit for the time period request. Valid values are listed below.}

\item{statistics}{[required] An array of statistics that you want to request metrics for. Valid
values are listed below.
\itemize{
\item \strong{\code{SampleCount}} - The count (number) of data points used for the
statistical calculation.
\item \strong{\code{Average}} - The value of Sum / SampleCount during the specified
period. By comparing this statistic with the Minimum and Maximum,
you can determine the full scope of a metric and how close the
average use is to the Minimum and Maximum. This comparison helps you
to know when to increase or decrease your resources as needed.
\item \strong{\code{Sum}} - All values submitted for the matching metric added
together. This statistic can be useful for determining the total
volume of a metric.
\item \strong{\code{Minimum}} - The lowest value observed during the specified
period. You can use this value to determine low volumes of activity
for your application.
\item \strong{\code{Maximum}} - The highest value observed during the specified
period. You can use this value to determine high volumes of activity
for your application.
}}
}
\description{
Returns information about health metrics for your Lightsail load
balancer.
}
\section{Request syntax}{
\preformatted{svc$get_load_balancer_metric_data(
  loadBalancerName = "string",
  metricName = "ClientTLSNegotiationErrorCount"|"HealthyHostCount"|"UnhealthyHostCount"|"HTTPCode_LB_4XX_Count"|"HTTPCode_LB_5XX_Count"|"HTTPCode_Instance_2XX_Count"|"HTTPCode_Instance_3XX_Count"|"HTTPCode_Instance_4XX_Count"|"HTTPCode_Instance_5XX_Count"|"InstanceResponseTime"|"RejectedConnectionCount"|"RequestCount",
  period = 123,
  startTime = as.POSIXct(
    "2015-01-01"
  ),
  endTime = as.POSIXct(
    "2015-01-01"
  ),
  unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None",
  statistics = list(
    "Minimum"|"Maximum"|"Sum"|"Average"|"SampleCount"
  )
)
}
}

\keyword{internal}
