% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_update_service_primary_task_set}
\alias{ecs_update_service_primary_task_set}
\title{Modifies which task set in a service is the primary task set}
\usage{
ecs_update_service_primary_task_set(cluster, service, primaryTaskSet)
}
\arguments{
\item{cluster}{[required] The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the service that the task set exists in.}

\item{service}{[required] The short name or full Amazon Resource Name (ARN) of the service that
the task set exists in.}

\item{primaryTaskSet}{[required] The short name or full Amazon Resource Name (ARN) of the task set to set
as the primary task set in the deployment.}
}
\description{
Modifies which task set in a service is the primary task set. Any
parameters that are updated on the primary task set in a service will
transition to the service. This is used when a service uses the
\code{EXTERNAL} deployment controller type. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html}{Amazon ECS Deployment Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_service_primary_task_set(
  cluster = "string",
  service = "string",
  primaryTaskSet = "string"
)
}
}

\keyword{internal}
