% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_revoke_security_group_egress}
\alias{ec2_revoke_security_group_egress}
\title{[VPC only] Removes the specified egress rules from a security
group for EC2-VPC}
\usage{
ec2_revoke_security_group_egress(DryRun, GroupId, IpPermissions, CidrIp,
  FromPort, IpProtocol, ToPort, SourceSecurityGroupName,
  SourceSecurityGroupOwnerId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{GroupId}{[required] The ID of the security group.}

\item{IpPermissions}{The sets of IP permissions. You can't specify a destination security
group and a CIDR IP address range in the same set of permissions.}

\item{CidrIp}{Not supported. Use a set of IP permissions to specify the CIDR.}

\item{FromPort}{Not supported. Use a set of IP permissions to specify the port.}

\item{IpProtocol}{Not supported. Use a set of IP permissions to specify the protocol name
or number.}

\item{ToPort}{Not supported. Use a set of IP permissions to specify the port.}

\item{SourceSecurityGroupName}{Not supported. Use a set of IP permissions to specify a destination
security group.}

\item{SourceSecurityGroupOwnerId}{Not supported. Use a set of IP permissions to specify a destination
security group.}
}
\description{
[VPC only] Removes the specified egress rules from a security group
for EC2-VPC. This action doesn't apply to security groups for use in
EC2-Classic. To remove a rule, the values that you specify (for example,
ports) must match the existing rule's values exactly.
}
\details{
Each rule consists of the protocol and the IPv4 or IPv6 CIDR range or
source security group. For the TCP and UDP protocols, you must also
specify the destination port or range of ports. For the ICMP protocol,
you must also specify the ICMP type and code. If the security group rule
has a description, you do not have to specify the description to revoke
the rule.

Rule changes are propagated to instances within the security group as
quickly as possible. However, a small delay might occur.
}
\section{Request syntax}{
\preformatted{svc$revoke_security_group_egress(
  DryRun = TRUE|FALSE,
  GroupId = "string",
  IpPermissions = list(
    list(
      FromPort = 123,
      IpProtocol = "string",
      IpRanges = list(
        list(
          CidrIp = "string",
          Description = "string"
        )
      ),
      Ipv6Ranges = list(
        list(
          CidrIpv6 = "string",
          Description = "string"
        )
      ),
      PrefixListIds = list(
        list(
          Description = "string",
          PrefixListId = "string"
        )
      ),
      ToPort = 123,
      UserIdGroupPairs = list(
        list(
          Description = "string",
          GroupId = "string",
          GroupName = "string",
          PeeringStatus = "string",
          UserId = "string",
          VpcId = "string",
          VpcPeeringConnectionId = "string"
        )
      )
    )
  ),
  CidrIp = "string",
  FromPort = 123,
  IpProtocol = "string",
  ToPort = 123,
  SourceSecurityGroupName = "string",
  SourceSecurityGroupOwnerId = "string"
)
}
}

\keyword{internal}
