% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_capacity_reservation}
\alias{ec2_modify_capacity_reservation}
\title{Modifies a Capacity Reservation's capacity and the conditions under
which it is to be released}
\usage{
ec2_modify_capacity_reservation(CapacityReservationId, InstanceCount,
  EndDate, EndDateType, DryRun)
}
\arguments{
\item{CapacityReservationId}{[required] The ID of the Capacity Reservation.}

\item{InstanceCount}{The number of instances for which to reserve capacity.}

\item{EndDate}{The date and time at which the Capacity Reservation expires. When a
Capacity Reservation expires, the reserved capacity is released and you
can no longer launch instances into it. The Capacity Reservation's
state changes to \code{expired} when it reaches its end date and time.

The Capacity Reservation is cancelled within an hour from the specified
time. For example, if you specify 5/31/2019, 13:30:55, the Capacity
Reservation is guaranteed to end between 13:30:55 and 14:30:55 on
5/31/2019.

You must provide an \code{EndDate} value if \code{EndDateType} is \code{limited}. Omit
\code{EndDate} if \code{EndDateType} is \code{unlimited}.}

\item{EndDateType}{Indicates the way in which the Capacity Reservation ends. A Capacity
Reservation can have one of the following end types:
\itemize{
\item \code{unlimited} - The Capacity Reservation remains active until you
explicitly cancel it. Do not provide an \code{EndDate} value if
\code{EndDateType} is \code{unlimited}.
\item \code{limited} - The Capacity Reservation expires automatically at a
specified date and time. You must provide an \code{EndDate} value if
\code{EndDateType} is \code{limited}.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies a Capacity Reservation's capacity and the conditions under
which it is to be released. You cannot change a Capacity Reservation's
instance type, EBS optimization, instance store settings, platform,
Availability Zone, or instance eligibility. If you need to modify any of
these attributes, we recommend that you cancel the Capacity Reservation,
and then create a new one with the required attributes.
}
\section{Request syntax}{
\preformatted{svc$modify_capacity_reservation(
  CapacityReservationId = "string",
  InstanceCount = 123,
  EndDate = as.POSIXct(
    "2015-01-01"
  ),
  EndDateType = "unlimited"|"limited",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
