% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_distributions}
\alias{lightsail_get_distributions}
\title{Returns information about one or more of your Amazon Lightsail content
delivery network (CDN) distributions}
\usage{
lightsail_get_distributions(distributionName, pageToken)
}
\arguments{
\item{distributionName}{The name of the distribution for which to return information.

Use the \code{\link[=lightsail_get_distributions]{get_distributions}} action to get
a list of distribution names that you can specify.

When omitted, the response includes all of your distributions in the AWS
Region where the request is made.}

\item{pageToken}{The token to advance to the next page of results from your request.

To get a page token, perform an initial
\code{\link[=lightsail_get_distributions]{get_distributions}} request. If your
results are paginated, the response will return a next page token that
you can specify as the page token in a subsequent request.}
}
\value{
A list with the following syntax:\preformatted{list(
  distributions = list(
    list(
      name = "string",
      arn = "string",
      supportCode = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      alternativeDomainNames = list(
        "string"
      ),
      status = "string",
      isEnabled = TRUE|FALSE,
      domainName = "string",
      bundleId = "string",
      certificateName = "string",
      origin = list(
        name = "string",
        resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2",
        protocolPolicy = "http-only"|"https-only"
      ),
      originPublicDNS = "string",
      defaultCacheBehavior = list(
        behavior = "dont-cache"|"cache"
      ),
      cacheBehaviorSettings = list(
        defaultTTL = 123,
        minimumTTL = 123,
        maximumTTL = 123,
        allowedHTTPMethods = "string",
        cachedHTTPMethods = "string",
        forwardedCookies = list(
          option = "none"|"allow-list"|"all",
          cookiesAllowList = list(
            "string"
          )
        ),
        forwardedHeaders = list(
          option = "none"|"allow-list"|"all",
          headersAllowList = list(
            "Accept"|"Accept-Charset"|"Accept-Datetime"|"Accept-Encoding"|"Accept-Language"|"Authorization"|"CloudFront-Forwarded-Proto"|"CloudFront-Is-Desktop-Viewer"|"CloudFront-Is-Mobile-Viewer"|"CloudFront-Is-SmartTV-Viewer"|"CloudFront-Is-Tablet-Viewer"|"CloudFront-Viewer-Country"|"Host"|"Origin"|"Referer"
          )
        ),
        forwardedQueryStrings = list(
          option = TRUE|FALSE,
          queryStringsAllowList = list(
            "string"
          )
        )
      ),
      cacheBehaviors = list(
        list(
          path = "string",
          behavior = "dont-cache"|"cache"
        )
      ),
      ableToUpdateBundle = TRUE|FALSE,
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      )
    )
  ),
  nextPageToken = "string"
)
}
}
\description{
Returns information about one or more of your Amazon Lightsail content
delivery network (CDN) distributions.
}
\section{Request syntax}{
\preformatted{svc$get_distributions(
  distributionName = "string",
  pageToken = "string"
)
}
}

\keyword{internal}
