% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_vpc}
\alias{ec2_create_vpc}
\title{Creates a VPC with the specified IPv4 CIDR block}
\usage{
ec2_create_vpc(CidrBlock, AmazonProvidedIpv6CidrBlock, Ipv6Pool,
  Ipv6CidrBlock, DryRun, InstanceTenancy, Ipv6CidrBlockNetworkBorderGroup,
  TagSpecifications)
}
\arguments{
\item{CidrBlock}{[required] The IPv4 network range for the VPC, in CIDR notation. For example,
\verb{10.0.0.0/16}. We modify the specified CIDR block to its canonical form;
for example, if you specify \verb{100.68.0.18/18}, we modify it to
\verb{100.68.0.0/18}.}

\item{AmazonProvidedIpv6CidrBlock}{Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
the VPC. You cannot specify the range of IP addresses, or the size of
the CIDR block.}

\item{Ipv6Pool}{The ID of an IPv6 address pool from which to allocate the IPv6 CIDR
block.}

\item{Ipv6CidrBlock}{The IPv6 CIDR block from the IPv6 address pool. You must also specify
\code{Ipv6Pool} in the request.

To let Amazon choose the IPv6 CIDR block for you, omit this parameter.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceTenancy}{The tenancy options for instances launched into the VPC. For \code{default},
instances are launched with shared tenancy by default. You can launch
instances with any tenancy into a shared tenancy VPC. For \code{dedicated},
instances are launched as dedicated tenancy instances by default. You
can only launch instances with a tenancy of \code{dedicated} or \code{host} into a
dedicated tenancy VPC.

\strong{Important:} The \code{host} value cannot be used with this parameter. Use
the \code{default} or \code{dedicated} values only.

Default: \code{default}}

\item{Ipv6CidrBlockNetworkBorderGroup}{The name of the location from which we advertise the IPV6 CIDR block.
Use this parameter to limit the address to this location.

You must set \code{AmazonProvidedIpv6CidrBlock} to \code{true} to use this
parameter.}

\item{TagSpecifications}{The tags to assign to the VPC.}
}
\value{
A list with the following syntax:\preformatted{list(
  Vpc = list(
    CidrBlock = "string",
    DhcpOptionsId = "string",
    State = "pending"|"available",
    VpcId = "string",
    OwnerId = "string",
    InstanceTenancy = "default"|"dedicated"|"host",
    Ipv6CidrBlockAssociationSet = list(
      list(
        AssociationId = "string",
        Ipv6CidrBlock = "string",
        Ipv6CidrBlockState = list(
          State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
          StatusMessage = "string"
        ),
        NetworkBorderGroup = "string",
        Ipv6Pool = "string"
      )
    ),
    CidrBlockAssociationSet = list(
      list(
        AssociationId = "string",
        CidrBlock = "string",
        CidrBlockState = list(
          State = "associating"|"associated"|"disassociating"|"disassociated"|"failing"|"failed",
          StatusMessage = "string"
        )
      )
    ),
    IsDefault = TRUE|FALSE,
    Tags = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you
can create uses a /28 netmask (16 IPv4 addresses), and the largest uses
a /16 netmask (65,536 IPv4 addresses). For more information about how
large to make your VPC, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html}{Your VPC and Subnets}
in the \emph{Amazon Virtual Private Cloud User Guide}.

You can optionally request an IPv6 CIDR block for the VPC. You can
request an Amazon-provided IPv6 CIDR block from Amazon's pool of IPv6
addresses, or an IPv6 CIDR block from an IPv6 address pool that you
provisioned through bring your own IP addresses
(\href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html}{BYOIP}).

By default, each instance you launch in the VPC has the default DHCP
options, which include only a default DNS server that we provide
(AmazonProvidedDNS). For more information, see \href{https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html}{DHCP Options Sets}
in the \emph{Amazon Virtual Private Cloud User Guide}.

You can specify the instance tenancy value for the VPC when you create
it. You can't change this value for the VPC after you create it. For
more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html}{Dedicated Instances}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_vpc(
  CidrBlock = "string",
  AmazonProvidedIpv6CidrBlock = TRUE|FALSE,
  Ipv6Pool = "string",
  Ipv6CidrBlock = "string",
  DryRun = TRUE|FALSE,
  InstanceTenancy = "default"|"dedicated"|"host",
  Ipv6CidrBlockNetworkBorderGroup = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\examples{
\dontrun{
# This example creates a VPC with the specified CIDR block.
svc$create_vpc(
  CidrBlock = "10.0.0.0/16"
)
}

}
\keyword{internal}
