% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_delete_event_source_mapping}
\alias{lambda_delete_event_source_mapping}
\title{Deletes an event source mapping}
\usage{
lambda_delete_event_source_mapping(UUID)
}
\arguments{
\item{UUID}{[required] The identifier of the event source mapping.}
}
\value{
A list with the following syntax:\preformatted{list(
  UUID = "string",
  StartingPosition = "TRIM_HORIZON"|"LATEST"|"AT_TIMESTAMP",
  StartingPositionTimestamp = as.POSIXct(
    "2015-01-01"
  ),
  BatchSize = 123,
  MaximumBatchingWindowInSeconds = 123,
  ParallelizationFactor = 123,
  EventSourceArn = "string",
  FunctionArn = "string",
  LastModified = as.POSIXct(
    "2015-01-01"
  ),
  LastProcessingResult = "string",
  State = "string",
  StateTransitionReason = "string",
  DestinationConfig = list(
    OnSuccess = list(
      Destination = "string"
    ),
    OnFailure = list(
      Destination = "string"
    )
  ),
  Topics = list(
    "string"
  ),
  Queues = list(
    "string"
  ),
  SourceAccessConfigurations = list(
    list(
      Type = "BASIC_AUTH"|"VPC_SUBNET"|"VPC_SECURITY_GROUP"|"SASL_SCRAM_512_AUTH"|"SASL_SCRAM_256_AUTH",
      URI = "string"
    )
  ),
  SelfManagedEventSource = list(
    Endpoints = list(
      list(
        "string"
      )
    )
  ),
  MaximumRecordAgeInSeconds = 123,
  BisectBatchOnFunctionError = TRUE|FALSE,
  MaximumRetryAttempts = 123,
  TumblingWindowInSeconds = 123,
  FunctionResponseTypes = list(
    "ReportBatchItemFailures"
  )
)
}
}
\description{
Deletes an \href{https://docs.aws.amazon.com/lambda/latest/dg/invocation-eventsourcemapping.html}{event source mapping}.
You can get the identifier of a mapping from the output of
\code{\link[=lambda_list_event_source_mappings]{list_event_source_mappings}}.

When you delete an event source mapping, it enters a \code{Deleting} state
and might not be completely deleted for several seconds.
}
\section{Request syntax}{
\preformatted{svc$delete_event_source_mapping(
  UUID = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes an event source mapping. To get a
# mapping's UUID, use ListEventSourceMappings.
svc$delete_event_source_mapping(
  UUID = "14e0db71-xmpl-4eb5-b481-8945cf9d10c2"
)
}

}
\keyword{internal}
