% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_retrieve_environment_info}
\alias{elasticbeanstalk_retrieve_environment_info}
\title{Retrieves the compiled information from a RequestEnvironmentInfo request}
\usage{
elasticbeanstalk_retrieve_environment_info(EnvironmentId,
  EnvironmentName, InfoType)
}
\arguments{
\item{EnvironmentId}{The ID of the data's environment.

If no such environment is found, returns an \code{InvalidParameterValue}
error.

Condition: You must specify either this or an EnvironmentName, or both.
If you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}

\item{EnvironmentName}{The name of the data's environment.

If no such environment is found, returns an \code{InvalidParameterValue}
error.

Condition: You must specify either this or an EnvironmentId, or both. If
you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}

\item{InfoType}{[required] The type of information to retrieve.}
}
\value{
A list with the following syntax:\preformatted{list(
  EnvironmentInfo = list(
    list(
      InfoType = "tail"|"bundle",
      Ec2InstanceId = "string",
      SampleTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      Message = "string"
    )
  )
)
}
}
\description{
Retrieves the compiled information from a
\code{\link[=elasticbeanstalk_request_environment_info]{request_environment_info}}
request.

Related Topics
\itemize{
\item \code{\link[=elasticbeanstalk_request_environment_info]{request_environment_info}}
}
}
\section{Request syntax}{
\preformatted{svc$retrieve_environment_info(
  EnvironmentId = "string",
  EnvironmentName = "string",
  InfoType = "tail"|"bundle"
)
}
}

\examples{
\dontrun{
# The following operation retrieves a link to logs from an environment
# named my-env:
svc$retrieve_environment_info(
  EnvironmentName = "my-env",
  InfoType = "tail"
)
}

}
\keyword{internal}
