% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_batch_get_image}
\alias{ecr_batch_get_image}
\title{Gets detailed information for an image}
\usage{
ecr_batch_get_image(registryId, repositoryName, imageIds,
  acceptedMediaTypes)
}
\arguments{
\item{registryId}{The AWS account ID associated with the registry that contains the images
to describe. If you do not specify a registry, the default registry is
assumed.}

\item{repositoryName}{[required] The repository that contains the images to describe.}

\item{imageIds}{[required] A list of image ID references that correspond to images to describe. The
format of the \code{imageIds} reference is \code{imageTag=tag} or
\code{imageDigest=digest}.}

\item{acceptedMediaTypes}{The accepted media types for the request.

Valid values: \code{application/vnd.docker.distribution.manifest.v1+json} |
\code{application/vnd.docker.distribution.manifest.v2+json} |
\code{application/vnd.oci.image.manifest.v1+json}}
}
\value{
A list with the following syntax:\preformatted{list(
  images = list(
    list(
      registryId = "string",
      repositoryName = "string",
      imageId = list(
        imageDigest = "string",
        imageTag = "string"
      ),
      imageManifest = "string",
      imageManifestMediaType = "string"
    )
  ),
  failures = list(
    list(
      imageId = list(
        imageDigest = "string",
        imageTag = "string"
      ),
      failureCode = "InvalidImageDigest"|"InvalidImageTag"|"ImageTagDoesNotMatchDigest"|"ImageNotFound"|"MissingDigestAndTag"|"ImageReferencedByManifestList"|"KmsError",
      failureReason = "string"
    )
  )
)
}
}
\description{
Gets detailed information for an image. Images are specified with either
an \code{imageTag} or \code{imageDigest}.

When an image is pulled, the BatchGetImage API is called once to
retrieve the image manifest.
}
\section{Request syntax}{
\preformatted{svc$batch_get_image(
  registryId = "string",
  repositoryName = "string",
  imageIds = list(
    list(
      imageDigest = "string",
      imageTag = "string"
    )
  ),
  acceptedMediaTypes = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example obtains information for an image with a specified image
# digest ID from the repository named ubuntu in the current account.
svc$batch_get_image(
  imageIds = list(
    list(
      imageTag = "precise"
    )
  ),
  repositoryName = "ubuntu"
)
}

}
\keyword{internal}
