% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_environment_resources}
\alias{elasticbeanstalk_describe_environment_resources}
\title{Returns AWS resources for this environment}
\usage{
elasticbeanstalk_describe_environment_resources(EnvironmentId,
  EnvironmentName)
}
\arguments{
\item{EnvironmentId}{The ID of the environment to retrieve AWS resource usage data.

Condition: You must specify either this or an EnvironmentName, or both.
If you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}

\item{EnvironmentName}{The name of the environment to retrieve AWS resource usage data.

Condition: You must specify either this or an EnvironmentId, or both. If
you do not specify either, AWS Elastic Beanstalk returns
\code{MissingRequiredParameter} error.}
}
\value{
A list with the following syntax:\preformatted{list(
  EnvironmentResources = list(
    EnvironmentName = "string",
    AutoScalingGroups = list(
      list(
        Name = "string"
      )
    ),
    Instances = list(
      list(
        Id = "string"
      )
    ),
    LaunchConfigurations = list(
      list(
        Name = "string"
      )
    ),
    LaunchTemplates = list(
      list(
        Id = "string"
      )
    ),
    LoadBalancers = list(
      list(
        Name = "string"
      )
    ),
    Triggers = list(
      list(
        Name = "string"
      )
    ),
    Queues = list(
      list(
        Name = "string",
        URL = "string"
      )
    )
  )
)
}
}
\description{
Returns AWS resources for this environment.
}
\section{Request syntax}{
\preformatted{svc$describe_environment_resources(
  EnvironmentId = "string",
  EnvironmentName = "string"
)
}
}

\examples{
\dontrun{
# The following operation retrieves information about resources in an
# environment named my-env:
svc$describe_environment_resources(
  EnvironmentName = "my-env"
)
}

}
\keyword{internal}
