% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_detach_certificate_from_distribution}
\alias{lightsail_detach_certificate_from_distribution}
\title{Detaches an SSL/TLS certificate from your Amazon Lightsail content
delivery network (CDN) distribution}
\usage{
lightsail_detach_certificate_from_distribution(distributionName)
}
\arguments{
\item{distributionName}{[required] The name of the distribution from which to detach the certificate.

Use the \code{GetDistributions} action to get a list of distribution names
that you can specify.}
}
\description{
Detaches an SSL/TLS certificate from your Amazon Lightsail content
delivery network (CDN) distribution.

After the certificate is detached, your distribution stops accepting
traffic for all of the domains that are associated with the certificate.
}
\section{Request syntax}{
\preformatted{svc$detach_certificate_from_distribution(
  distributionName = "string"
)
}
}

\keyword{internal}
