% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_update_function_code}
\alias{lambda_update_function_code}
\title{Updates a Lambda function's code}
\usage{
lambda_update_function_code(FunctionName, ZipFile, S3Bucket, S3Key,
  S3ObjectVersion, ImageUri, Publish, DryRun, RevisionId)
}
\arguments{
\item{FunctionName}{[required] The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \verb{my-function}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:my-function}.
\item \strong{Partial ARN} - \verb{123456789012:function:my-function}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it is limited to 64 characters in length.}

\item{ZipFile}{The base64-encoded contents of the deployment package. AWS SDK and AWS
CLI clients handle the encoding for you.}

\item{S3Bucket}{An Amazon S3 bucket in the same AWS Region as your function. The bucket
can be in a different AWS account.}

\item{S3Key}{The Amazon S3 key of the deployment package.}

\item{S3ObjectVersion}{For versioned objects, the version of the deployment package object to
use.}

\item{ImageUri}{URI of a container image in the Amazon ECR registry.}

\item{Publish}{Set to true to publish a new version of the function after updating the
code. This has the same effect as calling PublishVersion separately.}

\item{DryRun}{Set to true to validate the request parameters and access permissions
without modifying the function code.}

\item{RevisionId}{Only update the function if the revision ID matches the ID that's
specified. Use this option to avoid modifying a function that has
changed since you last read it.}
}
\description{
Updates a Lambda function's code. If code signing is enabled for the
function, the code package must be signed by a trusted publisher. For
more information, see \href{https://docs.aws.amazon.com/lambda/latest/dg/}{Configuring code signing}.

The function's code is locked when you publish a version. You can't
modify the code of a published version, only the unpublished version.

For a function defined as a container image, Lambda resolves the image
tag to an image digest. In Amazon ECR, if you update the image tag to a
new image, Lambda does not automatically update the function.
}
\section{Request syntax}{
\preformatted{svc$update_function_code(
  FunctionName = "string",
  ZipFile = raw,
  S3Bucket = "string",
  S3Key = "string",
  S3ObjectVersion = "string",
  ImageUri = "string",
  Publish = TRUE|FALSE,
  DryRun = TRUE|FALSE,
  RevisionId = "string"
)
}
}

\examples{
\dontrun{
# The following example replaces the code of the unpublished ($LATEST)
# version of a function named my-function with the contents of the
# specified zip file in Amazon S3.
svc$update_function_code(
  FunctionName = "my-function",
  S3Bucket = "my-bucket-1xpuxmplzrlbh",
  S3Key = "function.zip"
)
}

}
\keyword{internal}
