% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_delete_addon}
\alias{eks_delete_addon}
\title{Delete an Amazon EKS add-on}
\usage{
eks_delete_addon(clusterName, addonName)
}
\arguments{
\item{clusterName}{[required] The name of the cluster to delete the add-on from.}

\item{addonName}{[required] The name of the add-on. The name must match one of the names returned by
\href{https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html}{\code{ListAddons}}
.}
}
\description{
Delete an Amazon EKS add-on.

When you remove the add-on, it will also be deleted from the cluster.
You can always manually start an add-on on the cluster using the
Kubernetes API.
}
\section{Request syntax}{
\preformatted{svc$delete_addon(
  clusterName = "string",
  addonName = "string"
)
}
}

\keyword{internal}
