% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_accept_reserved_instances_exchange_quote}
\alias{ec2_accept_reserved_instances_exchange_quote}
\title{Accepts the Convertible Reserved Instance exchange quote described in
the GetReservedInstancesExchangeQuote call}
\usage{
ec2_accept_reserved_instances_exchange_quote(DryRun,
  ReservedInstanceIds, TargetConfigurations)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{ReservedInstanceIds}{[required] The IDs of the Convertible Reserved Instances to exchange for another
Convertible Reserved Instance of the same or higher value.}

\item{TargetConfigurations}{The configuration of the target Convertible Reserved Instance to
exchange for your current Convertible Reserved Instances.}
}
\description{
Accepts the Convertible Reserved Instance exchange quote described in
the GetReservedInstancesExchangeQuote call.
}
\section{Request syntax}{
\preformatted{svc$accept_reserved_instances_exchange_quote(
  DryRun = TRUE|FALSE,
  ReservedInstanceIds = list(
    "string"
  ),
  TargetConfigurations = list(
    list(
      InstanceCount = 123,
      OfferingId = "string"
    )
  )
)
}
}

\keyword{internal}
