% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_describe_events}
\alias{elasticbeanstalk_describe_events}
\title{Returns list of event descriptions matching criteria up to the last 6
weeks}
\usage{
elasticbeanstalk_describe_events(ApplicationName, VersionLabel,
  TemplateName, EnvironmentId, EnvironmentName, PlatformArn, RequestId,
  Severity, StartTime, EndTime, MaxRecords, NextToken)
}
\arguments{
\item{ApplicationName}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to include only those associated with this application.}

\item{VersionLabel}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those associated with this application version.}

\item{TemplateName}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those that are associated with this environment configuration.}

\item{EnvironmentId}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those associated with this environment.}

\item{EnvironmentName}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those associated with this environment.}

\item{PlatformArn}{The ARN of the version of the custom platform.}

\item{RequestId}{If specified, AWS Elastic Beanstalk restricts the described events to
include only those associated with this request ID.}

\item{Severity}{If specified, limits the events returned from this call to include only
those with the specified severity or higher.}

\item{StartTime}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those that occur on or after this time.}

\item{EndTime}{If specified, AWS Elastic Beanstalk restricts the returned descriptions
to those that occur up to, but not including, the \code{EndTime}.}

\item{MaxRecords}{Specifies the maximum number of events that can be returned, beginning
with the most recent event.}

\item{NextToken}{Pagination token. If specified, the events return the next batch of
results.}
}
\description{
Returns list of event descriptions matching criteria up to the last 6
weeks.
}
\details{
This action returns the most recent 1,000 events from the specified
\code{NextToken}.
}
\section{Request syntax}{
\preformatted{svc$describe_events(
  ApplicationName = "string",
  VersionLabel = "string",
  TemplateName = "string",
  EnvironmentId = "string",
  EnvironmentName = "string",
  PlatformArn = "string",
  RequestId = "string",
  Severity = "TRACE"|"DEBUG"|"INFO"|"WARN"|"ERROR"|"FATAL",
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  MaxRecords = 123,
  NextToken = "string"
)
}
}

\examples{
# The following operation retrieves events for an environment named
# my-env:
\donttest{svc$describe_events(
  EnvironmentName = "my-env"
)}

}
\keyword{internal}
