% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_describe_task_sets}
\alias{ecs_describe_task_sets}
\title{Describes the task sets in the specified cluster and service}
\usage{
ecs_describe_task_sets(cluster, service, taskSets)
}
\arguments{
\item{cluster}{[required] The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the service that the task sets exist in.}

\item{service}{[required] The short name or full Amazon Resource Name (ARN) of the service that
the task sets exist in.}

\item{taskSets}{The ID or full Amazon Resource Name (ARN) of task sets to describe.}
}
\description{
Describes the task sets in the specified cluster and service. This is
used when a service uses the \code{EXTERNAL} deployment controller type. For
more information, see \href{http://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html}{Amazon ECS Deployment Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_task_sets(
  cluster = "string",
  service = "string",
  taskSets = list(
    "string"
  )
)
}
}

\keyword{internal}
