% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_create_cluster}
\alias{ecs_create_cluster}
\title{Creates a new Amazon ECS cluster}
\usage{
ecs_create_cluster(clusterName, tags)
}
\arguments{
\item{clusterName}{The name of your cluster. If you do not specify a name for your cluster,
you create a cluster named \code{default}. Up to 255 letters (uppercase and
lowercase), numbers, hyphens, and underscores are allowed.}

\item{tags}{The metadata that you apply to the cluster to help you categorize and
organize them. Each tag consists of a key and an optional value, both of
which you define. Tag keys can have a maximum character length of 128
characters, and tag values can have a maximum length of 256 characters.}
}
\description{
Creates a new Amazon ECS cluster. By default, your account receives a
\code{default} cluster when you launch your first container instance.
However, you can create your own cluster with a unique name with the
\code{CreateCluster} action.
}
\details{
When you call the CreateCluster API operation, Amazon ECS attempts to
create the service-linked role for your account so that required
resources in other AWS services can be managed on your behalf. However,
if the IAM user that makes the call does not have permissions to create
the service-linked role, it is not created. For more information, see
\href{http://docs.aws.amazon.com/AmazonECS/latest/developerguide/using-service-linked-roles.html}{Using Service-Linked Roles for Amazon ECS}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_cluster(
  clusterName = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\examples{
# This example creates a cluster in your default region.
\donttest{svc$create_cluster(
  clusterName = "my_cluster"
)}

}
\keyword{internal}
