% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_terminate_instances}
\alias{ec2_terminate_instances}
\title{Shuts down one or more instances}
\usage{
ec2_terminate_instances(InstanceIds, DryRun)
}
\arguments{
\item{InstanceIds}{[required] One or more instance IDs.

Constraints: Up to 1000 instance IDs. We recommend breaking up this
request into smaller batches.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Shuts down one or more instances. This operation is idempotent; if you
terminate an instance more than once, each call succeeds.
}
\details{
If you specify multiple instances and the request fails (for example,
because of a single incorrect instance ID), none of the instances are
terminated.

Terminated instances remain visible after termination (for approximately
one hour).

By default, Amazon EC2 deletes all EBS volumes that were attached when
the instance launched. Volumes attached after instance launch continue
running.

You can stop, start, and terminate EBS-backed instances. You can only
terminate instance store-backed instances. What happens to an instance
differs if you stop it or terminate it. For example, when you stop an
instance, the root device and any other devices attached to the instance
persist. When you terminate an instance, any attached EBS volumes with
the \code{DeleteOnTermination} block device mapping parameter set to \code{true}
are automatically deleted. For more information about the differences
between stopping and terminating instances, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html}{Instance Lifecycle}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

For more information about troubleshooting, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstancesShuttingDown.html}{Troubleshooting Terminating Your Instance}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$terminate_instances(
  InstanceIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example terminates the specified EC2 instance.
\donttest{svc$terminate_instances(
  InstanceIds = list(
    "i-1234567890abcdef0"
  )
)}

}
\keyword{internal}
