% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locationservice_service.R
\name{locationservice}
\alias{locationservice}
\title{Amazon Location Service}
\usage{
locationservice(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
"Suite of geospatial services including Maps, Places, Routes, Tracking,
and Geofencing"
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- locationservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=locationservice_associate_tracker_consumer]{associate_tracker_consumer} \tab Creates an association between a geofence collection and a tracker resource\cr
\link[=locationservice_batch_delete_device_position_history]{batch_delete_device_position_history} \tab Deletes the position history of one or more devices from a tracker resource\cr
\link[=locationservice_batch_delete_geofence]{batch_delete_geofence} \tab Deletes a batch of geofences from a geofence collection\cr
\link[=locationservice_batch_evaluate_geofences]{batch_evaluate_geofences} \tab Evaluates device positions against the geofence geometries from a given geofence collection\cr
\link[=locationservice_batch_get_device_position]{batch_get_device_position} \tab Lists the latest device positions for requested devices\cr
\link[=locationservice_batch_put_geofence]{batch_put_geofence} \tab A batch request for storing geofence geometries into a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request\cr
\link[=locationservice_batch_update_device_position]{batch_update_device_position} \tab Uploads position update data for one or more devices to a tracker resource (up to 10 devices per batch)\cr
\link[=locationservice_calculate_route]{calculate_route} \tab Calculates a route given the following required parameters: DeparturePosition and DestinationPosition\cr
\link[=locationservice_calculate_route_matrix]{calculate_route_matrix} \tab Calculates a route matrix given the following required parameters: DeparturePositions and DestinationPositions\cr
\link[=locationservice_create_geofence_collection]{create_geofence_collection} \tab Creates a geofence collection, which manages and stores geofences\cr
\link[=locationservice_create_key]{create_key} \tab Creates an API key resource in your Amazon Web Services account, which lets you grant actions for Amazon Location resources to the API key bearer\cr
\link[=locationservice_create_map]{create_map} \tab Creates a map resource in your Amazon Web Services account, which provides map tiles of different styles sourced from global location data providers\cr
\link[=locationservice_create_place_index]{create_place_index} \tab Creates a place index resource in your Amazon Web Services account\cr
\link[=locationservice_create_route_calculator]{create_route_calculator} \tab Creates a route calculator resource in your Amazon Web Services account\cr
\link[=locationservice_create_tracker]{create_tracker} \tab Creates a tracker resource in your Amazon Web Services account, which lets you retrieve current and historical location of devices\cr
\link[=locationservice_delete_geofence_collection]{delete_geofence_collection} \tab Deletes a geofence collection from your Amazon Web Services account\cr
\link[=locationservice_delete_key]{delete_key} \tab Deletes the specified API key\cr
\link[=locationservice_delete_map]{delete_map} \tab Deletes a map resource from your Amazon Web Services account\cr
\link[=locationservice_delete_place_index]{delete_place_index} \tab Deletes a place index resource from your Amazon Web Services account\cr
\link[=locationservice_delete_route_calculator]{delete_route_calculator} \tab Deletes a route calculator resource from your Amazon Web Services account\cr
\link[=locationservice_delete_tracker]{delete_tracker} \tab Deletes a tracker resource from your Amazon Web Services account\cr
\link[=locationservice_describe_geofence_collection]{describe_geofence_collection} \tab Retrieves the geofence collection details\cr
\link[=locationservice_describe_key]{describe_key} \tab Retrieves the API key resource details\cr
\link[=locationservice_describe_map]{describe_map} \tab Retrieves the map resource details\cr
\link[=locationservice_describe_place_index]{describe_place_index} \tab Retrieves the place index resource details\cr
\link[=locationservice_describe_route_calculator]{describe_route_calculator} \tab Retrieves the route calculator resource details\cr
\link[=locationservice_describe_tracker]{describe_tracker} \tab Retrieves the tracker resource details\cr
\link[=locationservice_disassociate_tracker_consumer]{disassociate_tracker_consumer} \tab Removes the association between a tracker resource and a geofence collection\cr
\link[=locationservice_get_device_position]{get_device_position} \tab Retrieves a device's most recent position according to its sample time\cr
\link[=locationservice_get_device_position_history]{get_device_position_history} \tab Retrieves the device position history from a tracker resource within a specified range of time\cr
\link[=locationservice_get_geofence]{get_geofence} \tab Retrieves the geofence details from a geofence collection\cr
\link[=locationservice_get_map_glyphs]{get_map_glyphs} \tab Retrieves glyphs used to display labels on a map\cr
\link[=locationservice_get_map_sprites]{get_map_sprites} \tab Retrieves the sprite sheet corresponding to a map resource\cr
\link[=locationservice_get_map_style_descriptor]{get_map_style_descriptor} \tab Retrieves the map style descriptor from a map resource\cr
\link[=locationservice_get_map_tile]{get_map_tile} \tab Retrieves a vector data tile from the map resource\cr
\link[=locationservice_get_place]{get_place} \tab Finds a place by its unique ID\cr
\link[=locationservice_list_device_positions]{list_device_positions} \tab A batch request to retrieve all device positions\cr
\link[=locationservice_list_geofence_collections]{list_geofence_collections} \tab Lists geofence collections in your Amazon Web Services account\cr
\link[=locationservice_list_geofences]{list_geofences} \tab Lists geofences stored in a given geofence collection\cr
\link[=locationservice_list_keys]{list_keys} \tab Lists API key resources in your Amazon Web Services account\cr
\link[=locationservice_list_maps]{list_maps} \tab Lists map resources in your Amazon Web Services account\cr
\link[=locationservice_list_place_indexes]{list_place_indexes} \tab Lists place index resources in your Amazon Web Services account\cr
\link[=locationservice_list_route_calculators]{list_route_calculators} \tab Lists route calculator resources in your Amazon Web Services account\cr
\link[=locationservice_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of tags that are applied to the specified Amazon Location resource\cr
\link[=locationservice_list_tracker_consumers]{list_tracker_consumers} \tab Lists geofence collections currently associated to the given tracker resource\cr
\link[=locationservice_list_trackers]{list_trackers} \tab Lists tracker resources in your Amazon Web Services account\cr
\link[=locationservice_put_geofence]{put_geofence} \tab Stores a geofence geometry in a given geofence collection, or updates the geometry of an existing geofence if a geofence ID is included in the request\cr
\link[=locationservice_search_place_index_for_position]{search_place_index_for_position} \tab Reverse geocodes a given coordinate and returns a legible address\cr
\link[=locationservice_search_place_index_for_suggestions]{search_place_index_for_suggestions} \tab Generates suggestions for addresses and points of interest based on partial or misspelled free-form text\cr
\link[=locationservice_search_place_index_for_text]{search_place_index_for_text} \tab Geocodes free-form text, such as an address, name, city, or region to allow you to search for Places or points of interest\cr
\link[=locationservice_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified Amazon Location Service resource\cr
\link[=locationservice_untag_resource]{untag_resource} \tab Removes one or more tags from the specified Amazon Location resource\cr
\link[=locationservice_update_geofence_collection]{update_geofence_collection} \tab Updates the specified properties of a given geofence collection\cr
\link[=locationservice_update_key]{update_key} \tab Updates the specified properties of a given API key resource\cr
\link[=locationservice_update_map]{update_map} \tab Updates the specified properties of a given map resource\cr
\link[=locationservice_update_place_index]{update_place_index} \tab Updates the specified properties of a given place index resource\cr
\link[=locationservice_update_route_calculator]{update_route_calculator} \tab Updates the specified properties for a given route calculator resource\cr
\link[=locationservice_update_tracker]{update_tracker} \tab Updates the specified properties of a given tracker resource
}
}

\examples{
\dontrun{
svc <- locationservice()
svc$associate_tracker_consumer(
  Foo = 123
)
}

}
