# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AmazonMWAA
#'
#' @description
#' Amazon Managed Workflows for Apache Airflow
#' 
#' This section contains the Amazon Managed Workflows for Apache Airflow
#' (MWAA) API reference documentation. For more information, see [What is
#' Amazon
#' MWAA?](https://docs.aws.amazon.com/mwaa/latest/userguide/what-is-mwaa.html).
#' 
#' **Endpoints**
#' 
#' -   `api.airflow.{region}.amazonaws.com` - This endpoint is used for
#'     environment management.
#' 
#'     -   [`create_environment`][mwaa_create_environment]
#' 
#'     -   [`delete_environment`][mwaa_delete_environment]
#' 
#'     -   [`get_environment`][mwaa_get_environment]
#' 
#'     -   [`list_environments`][mwaa_list_environments]
#' 
#'     -   [`list_tags_for_resource`][mwaa_list_tags_for_resource]
#' 
#'     -   [`tag_resource`][mwaa_tag_resource]
#' 
#'     -   [`untag_resource`][mwaa_untag_resource]
#' 
#'     -   [`update_environment`][mwaa_update_environment]
#' 
#' -   `env.airflow.{region}.amazonaws.com` - This endpoint is used to
#'     operate the Airflow environment.
#' 
#'     -   [`create_cli_token`][mwaa_create_cli_token]
#' 
#'     -   [`create_web_login_token`][mwaa_create_web_login_token]
#' 
#' -   `ops.airflow.{region}.amazonaws.com` - This endpoint is used to push
#'     environment metrics that track environment health.
#' 
#'     -   [`publish_metrics`][mwaa_publish_metrics]
#' 
#' **Regions**
#' 
#' For a list of regions that Amazon MWAA supports, see [Region
#' availability](https://docs.aws.amazon.com/mwaa/latest/userguide/what-is-mwaa.html#regions-mwaa)
#' in the *Amazon MWAA User Guide*.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}:} {\itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' }}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}:} {\itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' }}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- mwaa(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- mwaa()
#' svc$create_cli_token(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=mwaa_create_cli_token]{create_cli_token} \tab Creates a CLI token for the Airflow CLI\cr
#'  \link[=mwaa_create_environment]{create_environment} \tab Creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
#'  \link[=mwaa_create_web_login_token]{create_web_login_token} \tab Creates a web login token for the Airflow Web UI\cr
#'  \link[=mwaa_delete_environment]{delete_environment} \tab Deletes an Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
#'  \link[=mwaa_get_environment]{get_environment} \tab Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
#'  \link[=mwaa_list_environments]{list_environments} \tab Lists the Amazon Managed Workflows for Apache Airflow (MWAA) environments\cr
#'  \link[=mwaa_list_tags_for_resource]{list_tags_for_resource} \tab Lists the key-value tag pairs associated to the Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
#'  \link[=mwaa_publish_metrics]{publish_metrics} \tab Internal only\cr
#'  \link[=mwaa_tag_resource]{tag_resource} \tab Associates key-value tag pairs to your Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
#'  \link[=mwaa_untag_resource]{untag_resource} \tab Removes key-value tag pairs associated to your Amazon Managed Workflows for Apache Airflow (MWAA) environment\cr
#'  \link[=mwaa_update_environment]{update_environment} \tab Updates an Amazon Managed Workflows for Apache Airflow (MWAA) environment
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname mwaa
#' @export
mwaa <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .mwaa$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.mwaa <- list()

.mwaa$operations <- list()

.mwaa$metadata <- list(
  service_name = "mwaa",
  endpoints = list("*" = list(endpoint = "airflow.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "airflow.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "airflow.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "airflow.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "MWAA",
  api_version = "2020-07-01",
  signing_name = "airflow",
  json_version = "1.1",
  target_prefix = ""
)

.mwaa$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.mwaa$metadata, handlers, config)
}
