% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_get_queue_url}
\alias{sqs_get_queue_url}
\title{Returns the URL of an existing Amazon SQS queue}
\usage{
sqs_get_queue_url(QueueName, QueueOwnerAWSAccountId)
}
\arguments{
\item{QueueName}{[required] The name of the queue whose URL must be fetched. Maximum 80 characters.
Valid values: alphanumeric characters, hyphens (\code{-}), and underscores
(\code{_}).

Queue URLs and names are case-sensitive.}

\item{QueueOwnerAWSAccountId}{The AWS account ID of the account that created the queue.}
}
\description{
Returns the URL of an existing Amazon SQS queue.
}
\details{
To access a queue that belongs to another AWS account, use the
\code{QueueOwnerAWSAccountId} parameter to specify the account ID of the
queue's owner. The queue's owner must grant you permission to access
the queue. For more information about shared queue access, see
\code{<a>AddPermission</a>} or see \href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-writing-an-sqs-policy.html#write-messages-to-shared-queue}{Allow Developers to Write Messages to a Shared Queue}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$get_queue_url(
  QueueName = "string",
  QueueOwnerAWSAccountId = "string"
)
}
}

\keyword{internal}
