% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_integration_table_properties}
\alias{glue_create_integration_table_properties}
\title{This API is used to provide optional override properties for the the
tables that need to be replicated}
\usage{
glue_create_integration_table_properties(
  ResourceArn,
  TableName,
  SourceTableConfig = NULL,
  TargetTableConfig = NULL
)
}
\arguments{
\item{ResourceArn}{[required] The connection ARN of the source, or the database ARN of the target.}

\item{TableName}{[required] The name of the table to be replicated.}

\item{SourceTableConfig}{A structure for the source table configuration.}

\item{TargetTableConfig}{A structure for the target table configuration.}
}
\description{
This API is used to provide optional override properties for the the tables that need to be replicated. These properties can include properties for filtering and partitioning for the source and target tables. To set both source and target properties the same API need to be invoked with the Glue connection ARN as \code{ResourceArn} with \code{SourceTableConfig}, and the Glue database ARN as \code{ResourceArn} with \code{TargetTableConfig} respectively.

See \url{https://www.paws-r-sdk.com/docs/glue_create_integration_table_properties/} for full documentation.
}
\keyword{internal}
