% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opensearchserviceserverless_operations.R
\name{opensearchserviceserverless_update_security_config}
\alias{opensearchserviceserverless_update_security_config}
\title{Updates a security configuration for OpenSearch Serverless}
\usage{
opensearchserviceserverless_update_security_config(
  clientToken = NULL,
  configVersion,
  description = NULL,
  id,
  samlOptions = NULL
)
}
\arguments{
\item{clientToken}{Unique, case-sensitive identifier to ensure idempotency of the request.}

\item{configVersion}{[required] The version of the security configuration to be updated. You can find
the most recent version of a security configuration using the
\code{\link[=opensearchserviceserverless_get_security_policy]{get_security_policy}}
command.}

\item{description}{A description of the security configuration.}

\item{id}{[required] The security configuration identifier. For SAML the ID will be
\verb{saml/<accountId>/<idpProviderName>}. For example,
\code{saml/123456789123/OKTADev}.}

\item{samlOptions}{SAML options in in the form of a key-value map.}
}
\description{
Updates a security configuration for OpenSearch Serverless. For more information, see \href{https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html}{SAML authentication for Amazon OpenSearch Serverless}.

See \url{https://www.paws-r-sdk.com/docs/opensearchserviceserverless_update_security_config/} for full documentation.
}
\keyword{internal}
