% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_add_application_reference_data_source}
\alias{kinesisanalyticsv2_add_application_reference_data_source}
\title{Adds a reference data source to an existing SQL-based Kinesis Data
Analytics application}
\usage{
kinesisanalyticsv2_add_application_reference_data_source(
  ApplicationName,
  CurrentApplicationVersionId,
  ReferenceDataSource
)
}
\arguments{
\item{ApplicationName}{[required] The name of an existing application.}

\item{CurrentApplicationVersionId}{[required] The version of the application for which you are adding the reference
data source. You can use the
\code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}
operation to get the current application version. If the version
specified is not the current version, the
\code{ConcurrentModificationException} is returned.}

\item{ReferenceDataSource}{[required] The reference data source can be an object in your Amazon S3 bucket.
Kinesis Data Analytics reads the object and copies the data into the
in-application table that is created. You provide an S3 bucket, object
key name, and the resulting in-application table that is created.}
}
\description{
Adds a reference data source to an existing SQL-based Kinesis Data Analytics application.

See \url{https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_add_application_reference_data_source/} for full documentation.
}
\keyword{internal}
