% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_create_application}
\alias{kinesisanalyticsv2_create_application}
\title{Creates a Kinesis Data Analytics application}
\usage{
kinesisanalyticsv2_create_application(
  ApplicationName,
  ApplicationDescription = NULL,
  RuntimeEnvironment,
  ServiceExecutionRole,
  ApplicationConfiguration = NULL,
  CloudWatchLoggingOptions = NULL,
  Tags = NULL,
  ApplicationMode = NULL
)
}
\arguments{
\item{ApplicationName}{[required] The name of your application (for example, \code{sample-app}).}

\item{ApplicationDescription}{A summary description of the application.}

\item{RuntimeEnvironment}{[required] The runtime environment for the application.}

\item{ServiceExecutionRole}{[required] The IAM role used by the application to access Kinesis data streams,
Kinesis Data Firehose delivery streams, Amazon S3 objects, and other
external resources.}

\item{ApplicationConfiguration}{Use this parameter to configure the application.}

\item{CloudWatchLoggingOptions}{Use this parameter to configure an Amazon CloudWatch log stream to
monitor application configuration errors.}

\item{Tags}{A list of one or more tags to assign to the application. A tag is a
key-value pair that identifies an application. Note that the maximum
number of application tags includes system tags. The maximum number of
user-defined application tags is 50. For more information, see \href{https://docs.aws.amazon.com/kinesisanalytics/latest/java/how-tagging.html}{Using Tagging}.}

\item{ApplicationMode}{Use the \code{STREAMING} mode to create a Kinesis Data Analytics For Flink
application. To create a Kinesis Data Analytics Studio notebook, use the
\code{INTERACTIVE} mode.}
}
\description{
Creates a Kinesis Data Analytics application. For information about creating a Kinesis Data Analytics application, see \href{https://docs.aws.amazon.com/kinesisanalytics/latest/java/getting-started.html}{Creating an Application}.

See \url{https://www.paws-r-sdk.com/docs/kinesisanalyticsv2_create_application/} for full documentation.
}
\keyword{internal}
