% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivs_operations.R
\name{ivs_create_recording_configuration}
\alias{ivs_create_recording_configuration}
\title{Creates a new recording configuration, used to enable recording to
Amazon S3}
\usage{
ivs_create_recording_configuration(
  destinationConfiguration,
  name = NULL,
  tags = NULL,
  thumbnailConfiguration = NULL
)
}
\arguments{
\item{destinationConfiguration}{[required] A complex type that contains a destination configuration for where
recorded video will be stored.}

\item{name}{Recording-configuration name. The value does not need to be unique.}

\item{tags}{Array of 1-50 maps, each of the form \code{string:string (key:value)}.}

\item{thumbnailConfiguration}{A complex type that allows you to enable/disable the recording of
thumbnails for a live session and modify the interval at which
thumbnails are generated for the live session.}
}
\description{
Creates a new recording configuration, used to enable recording to Amazon S3.

See \url{https://paws-r.github.io/docs/ivs/create_recording_configuration.html} for full documentation.
}
\keyword{internal}
