% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gluedatabrew_operations.R
\name{gluedatabrew_create_schedule}
\alias{gluedatabrew_create_schedule}
\title{Creates a new schedule for one or more DataBrew jobs}
\usage{
gluedatabrew_create_schedule(
  JobNames = NULL,
  CronExpression,
  Tags = NULL,
  Name
)
}
\arguments{
\item{JobNames}{The name or names of one or more jobs to be run.}

\item{CronExpression}{[required] The date or dates and time or times when the jobs are to be run. For
more information, see \href{https://docs.aws.amazon.com/databrew/latest/dg/}{Cron expressions} in the
\emph{Glue DataBrew Developer Guide}.}

\item{Tags}{Metadata tags to apply to this schedule.}

\item{Name}{[required] A unique name for the schedule. Valid characters are alphanumeric (A-Z,
a-z, 0-9), hyphen (-), period (.), and space.}
}
\description{
Creates a new schedule for one or more DataBrew jobs. Jobs can be run at a specific date and time, or at regular intervals.

See \url{https://paws-r.github.io/docs/gluedatabrew/create_schedule.html} for full documentation.
}
\keyword{internal}
