% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_delete_table}
\alias{glue_delete_table}
\title{Removes a table definition from the Data Catalog}
\usage{
glue_delete_table(CatalogId, DatabaseName, Name)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog where the table resides. If none is provided,
the AWS account ID is used by default.}

\item{DatabaseName}{[required] The name of the catalog database in which the table resides. For Hive
compatibility, this name is entirely lowercase.}

\item{Name}{[required] The name of the table to be deleted. For Hive compatibility, this name
is entirely lowercase.}
}
\description{
Removes a table definition from the Data Catalog.
}
\details{
After completing this operation, you no longer have access to the table
versions and partitions that belong to the deleted table. AWS Glue
deletes these \"orphaned\" resources asynchronously in a timely manner,
at the discretion of the service.

To ensure the immediate deletion of all related resources, before
calling \code{DeleteTable}, use \code{DeleteTableVersion} or
\code{BatchDeleteTableVersion}, and \code{DeletePartition} or
\code{BatchDeletePartition}, to delete any resources that belong to the
table.
}
\section{Request syntax}{
\preformatted{svc$delete_table(
  CatalogId = "string",
  DatabaseName = "string",
  Name = "string"
)
}
}

\keyword{internal}
